/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.paper.util;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.minecraft.server.level.WorldServer;
import xyz.jpenilla.squaremap.common.Logging;
import xyz.jpenilla.squaremap.common.config.AbstractConfig;
import xyz.jpenilla.squaremap.common.data.DirectoryProvider;
import xyz.jpenilla.squaremap.common.util.Util;
import xyz.jpenilla.squaremap.paper.util.CraftBukkitReflection;

public final class WorldNameToKeyMigration {
    private WorldNameToKeyMigration() {
    }

    public static void migrate(AbstractConfig config, WorldServer level) {
        String oldName = CraftBukkitReflection.world(level).getName();
        config.migrateLevelSection(level, oldName);
    }

    public static void tryMoveDirectories(DirectoryProvider directoryProvider, WorldServer level) {
        try {
            WorldNameToKeyMigration.moveDirectories(directoryProvider, level);
        }
        catch (IOException ex) {
            Logging.logger().error("Failed to migrate directories for '{}'", (Object)level.ac().a());
        }
    }

    private static void moveDirectories(DirectoryProvider directoryProvider, WorldServer level) throws IOException {
        Path data;
        Path dataFrom;
        String oldName = CraftBukkitReflection.world(level).getName();
        String webName = Util.levelWebName(level);
        Path tilesFrom = directoryProvider.tilesDirectory().resolve(oldName);
        if (Files.exists(tilesFrom, new LinkOption[0])) {
            Path tilesDest = directoryProvider.tilesDirectory().resolve(webName);
            Files.move(tilesFrom, tilesDest, new CopyOption[0]);
        }
        if (Files.exists(dataFrom = (data = directoryProvider.dataDirectory().resolve("data")).resolve(oldName), new LinkOption[0])) {
            Path dataDest = data.resolve(webName);
            Files.move(dataFrom, dataDest, new CopyOption[0]);
        }
    }
}

