/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.paper.util;

import org.bukkit.Server;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import squaremap.libraries.com.google.inject.Inject;
import xyz.jpenilla.squaremap.common.command.Commander;
import xyz.jpenilla.squaremap.common.util.EntityScheduler;
import xyz.jpenilla.squaremap.paper.command.PaperCommander;
import xyz.jpenilla.squaremap.paper.util.Folia;

public final class PaperEntityScheduler
implements EntityScheduler {
    private final Server server;
    private final JavaPlugin plugin;

    @Inject
    private PaperEntityScheduler(Server server, JavaPlugin plugin) {
        this.server = server;
        this.plugin = plugin;
    }

    @Override
    public void scheduleFor(net.minecraft.world.entity.Entity entity, Runnable task) {
        if (Folia.FOLIA) {
            entity.getBukkitEntity().getScheduler().execute((Plugin)this.plugin, task, null, 0L);
        } else {
            task.run();
        }
    }

    @Override
    public void scheduleFor(Commander commander, Runnable task) {
        if (!Folia.FOLIA) {
            task.run();
            return;
        }
        CommandSender sender = ((PaperCommander)commander).sender();
        if (sender instanceof Entity) {
            Entity entity = (Entity)sender;
            entity.getScheduler().execute((Plugin)this.plugin, task, null, 0L);
        } else if (sender instanceof BlockCommandSender) {
            BlockCommandSender block = (BlockCommandSender)sender;
            this.server.getRegionScheduler().execute((Plugin)this.plugin, block.getBlock().getLocation(), task);
        } else {
            this.server.getGlobalRegionScheduler().execute((Plugin)this.plugin, task);
        }
    }
}

