/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.paper.util;

import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.World;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.checkerframework.checker.nullness.qual.NonNull;
import xyz.jpenilla.squaremap.common.util.ReflectionUtil;

public final class CraftBukkitReflection {
    private static final String PREFIX_CRAFTBUKKIT = "org.bukkit.craftbukkit";
    private static final String CRAFT_SERVER = "CraftServer";
    private static final String CB_PKG_VERSION;
    private static final Class<?> CRAFT_WORLD_CLASS;
    private static final Method CRAFT_WORLD_GET_HANDLE;
    private static final Class<?> CRAFT_PLAYER_CLASS;
    private static final Method CRAFT_PLAYER_GET_HANDLE;
    private static final Method LEVEL_GET_WORLD;
    private static final Method BUKKIT_PLAYER;

    private CraftBukkitReflection() {
    }

    public static @NonNull Class<?> needOBCClass(@NonNull String className) {
        return ReflectionUtil.needClass(PREFIX_CRAFTBUKKIT + CB_PKG_VERSION + className);
    }

    public static @NonNull WorldServer serverLevel(@NonNull org.bukkit.World world) {
        try {
            return (WorldServer)CRAFT_WORLD_GET_HANDLE.invoke((Object)world, new Object[0]);
        }
        catch (ReflectiveOperationException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static @NonNull EntityPlayer serverPlayer(@NonNull Player player) {
        try {
            return (EntityPlayer)CRAFT_PLAYER_GET_HANDLE.invoke((Object)player, new Object[0]);
        }
        catch (ReflectiveOperationException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static @NonNull org.bukkit.World world(@NonNull WorldServer level) {
        try {
            return (org.bukkit.World)LEVEL_GET_WORLD.invoke((Object)level, new Object[0]);
        }
        catch (ReflectiveOperationException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static @NonNull Player player(@NonNull EntityPlayer player) {
        try {
            return (Player)BUKKIT_PLAYER.invoke((Object)player, new Object[0]);
        }
        catch (ReflectiveOperationException ex) {
            throw new RuntimeException(ex);
        }
    }

    static {
        Class<?> serverClass = Bukkit.getServer().getClass();
        String name = serverClass.getName();
        name = name.substring(PREFIX_CRAFTBUKKIT.length());
        CB_PKG_VERSION = name = name.substring(0, name.length() - CRAFT_SERVER.length());
        CRAFT_WORLD_CLASS = CraftBukkitReflection.needOBCClass("CraftWorld");
        CRAFT_WORLD_GET_HANDLE = ReflectionUtil.needMethod(CRAFT_WORLD_CLASS, List.of("getHandle"), new Class[0]);
        CRAFT_PLAYER_CLASS = CraftBukkitReflection.needOBCClass("entity.CraftPlayer");
        CRAFT_PLAYER_GET_HANDLE = ReflectionUtil.needMethod(CRAFT_PLAYER_CLASS, List.of("getHandle"), new Class[0]);
        LEVEL_GET_WORLD = ReflectionUtil.needMethod(World.class, List.of("getWorld"), new Class[0]);
        BUKKIT_PLAYER = ReflectionUtil.needMethod(EntityPlayer.class, List.of("getBukkitEntity"), new Class[0]);
    }
}

