/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.paper.data;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.server.level.WorldServer;
import org.bukkit.Server;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;
import squaremap.libraries.com.google.inject.assistedinject.Assisted;
import squaremap.libraries.com.google.inject.assistedinject.AssistedInject;
import xyz.jpenilla.squaremap.common.config.ConfigManager;
import xyz.jpenilla.squaremap.common.data.DirectoryProvider;
import xyz.jpenilla.squaremap.common.data.MapWorldInternal;
import xyz.jpenilla.squaremap.common.task.UpdateMarkers;
import xyz.jpenilla.squaremap.common.task.render.RenderFactory;
import xyz.jpenilla.squaremap.common.util.ExceptionLoggingScheduledThreadPoolExecutor;
import xyz.jpenilla.squaremap.common.util.Util;
import xyz.jpenilla.squaremap.paper.util.Folia;

public final class PaperMapWorld
extends MapWorldInternal {
    private final MarkerTaskHandler markerTaskHandler;

    @AssistedInject
    private PaperMapWorld(@Assisted WorldServer level, JavaPlugin plugin, RenderFactory renderFactory, DirectoryProvider directoryProvider, Server server, ConfigManager configManager) {
        super(level, renderFactory, directoryProvider, configManager);
        this.markerTaskHandler = Folia.FOLIA ? new FoliaMarkerTaskHandler(level) : new PaperMarkerTaskHandler(plugin, server);
    }

    @Override
    public void shutdown() {
        this.markerTaskHandler.shutdown();
        super.shutdown();
    }

    private final class FoliaMarkerTaskHandler
    implements MarkerTaskHandler {
        private final ScheduledExecutorService markerThread;
        private final ScheduledFuture<?> updateMarkersTask;

        private FoliaMarkerTaskHandler(WorldServer level) {
            this.markerThread = new ExceptionLoggingScheduledThreadPoolExecutor(1, Util.squaremapThreadFactory("markers", level));
            this.updateMarkersTask = this.markerThread.scheduleAtFixedRate(new UpdateMarkers(PaperMapWorld.this), 5L, PaperMapWorld.this.config().MARKER_API_UPDATE_INTERVAL_SECONDS, TimeUnit.SECONDS);
        }

        @Override
        public void shutdown() {
            this.updateMarkersTask.cancel(false);
            Util.shutdownExecutor(this.markerThread, TimeUnit.MILLISECONDS, 100L);
        }
    }

    private static interface MarkerTaskHandler {
        public void shutdown();
    }

    private final class PaperMarkerTaskHandler
    implements MarkerTaskHandler {
        private final BukkitTask updateMarkersTask;

        private PaperMarkerTaskHandler(JavaPlugin plugin, Server server) {
            this.updateMarkersTask = server.getScheduler().runTaskTimer((Plugin)plugin, (Runnable)new UpdateMarkers(PaperMapWorld.this), 100L, 20L * (long)PaperMapWorld.this.config().MARKER_API_UPDATE_INTERVAL_SECONDS);
        }

        @Override
        public void shutdown() {
            this.updateMarkersTask.cancel();
        }
    }
}

