/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.paper.command;

import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.ReentrantLock;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.EntityPlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.checkerframework.checker.nullness.qual.Nullable;
import squaremap.libraries.cloud.commandframework.Command;
import squaremap.libraries.cloud.commandframework.CommandManager;
import squaremap.libraries.cloud.commandframework.CommandTree;
import squaremap.libraries.cloud.commandframework.arguments.CommandArgument;
import squaremap.libraries.cloud.commandframework.bukkit.arguments.selector.SinglePlayerSelector;
import squaremap.libraries.cloud.commandframework.bukkit.parsers.location.Location2DArgument;
import squaremap.libraries.cloud.commandframework.bukkit.parsers.selector.SinglePlayerSelectorArgument;
import squaremap.libraries.cloud.commandframework.context.CommandContext;
import squaremap.libraries.cloud.commandframework.exceptions.CommandExecutionException;
import squaremap.libraries.cloud.commandframework.execution.CommandExecutionCoordinator;
import squaremap.libraries.cloud.commandframework.execution.CommandResult;
import squaremap.libraries.cloud.commandframework.paper.PaperCommandManager;
import squaremap.libraries.cloud.commandframework.services.State;
import squaremap.libraries.cloud.commandframework.types.tuples.Pair;
import squaremap.libraries.com.google.inject.Inject;
import squaremap.libraries.com.google.inject.Singleton;
import xyz.jpenilla.squaremap.common.command.BrigadierSetup;
import xyz.jpenilla.squaremap.common.command.Commander;
import xyz.jpenilla.squaremap.common.command.PlatformCommands;
import xyz.jpenilla.squaremap.common.command.PlayerCommander;
import xyz.jpenilla.squaremap.common.command.exception.CommandCompleted;
import xyz.jpenilla.squaremap.common.config.Messages;
import xyz.jpenilla.squaremap.common.util.Components;
import xyz.jpenilla.squaremap.paper.command.PaperCommander;
import xyz.jpenilla.squaremap.paper.util.CraftBukkitReflection;
import xyz.jpenilla.squaremap.paper.util.Folia;

@Singleton
public final class PaperCommands
implements PlatformCommands {
    private final JavaPlugin plugin;

    @Inject
    private PaperCommands(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public CommandManager<Commander> createCommandManager() {
        PaperCommandManager<Commander> mgr;
        try {
            mgr = new PaperCommandManager<Commander>((Plugin)this.plugin, ExecutionCoordinator::new, PaperCommander::from, commander -> ((PaperCommander)commander).sender());
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to initialize command manager", ex);
        }
        mgr.registerBrigadier();
        BrigadierSetup.setup(mgr);
        mgr.registerAsynchronousCompletions();
        return mgr;
    }

    @Override
    public CommandArgument<Commander, ?> columnPosArgument(String name) {
        return Location2DArgument.optional(name);
    }

    @Override
    public @Nullable BlockPosition extractColumnPos(String argName, CommandContext<Commander> context) {
        return context.getOptional(argName).map(loc -> new BlockPosition(loc.getBlockX(), 0, loc.getBlockZ())).orElse(null);
    }

    @Override
    public CommandArgument<Commander, ?> singlePlayerSelectorArgument(String name) {
        return SinglePlayerSelectorArgument.of(name);
    }

    @Override
    public EntityPlayer extractPlayer(String argName, CommandContext<Commander> context) {
        Commander sender = context.getSender();
        @Nullable SinglePlayerSelector selector = context.getOrDefault(argName, null);
        if (selector == null) {
            if (sender instanceof PlayerCommander) {
                PlayerCommander player = (PlayerCommander)sender;
                return player.player();
            }
            throw CommandCompleted.withMessage(Messages.CONSOLE_MUST_SPECIFY_PLAYER);
        }
        @Nullable Player targetPlayer = selector.getPlayer();
        if (targetPlayer == null) {
            throw CommandCompleted.withMessage((ComponentLike)Messages.PLAYER_NOT_FOUND_FOR_INPUT.withPlaceholders(new TagResolver[]{Components.placeholder("input", selector.getSelector())}));
        }
        return CraftBukkitReflection.serverPlayer(targetPlayer);
    }

    private static final class ExecutionCoordinator<C>
    extends CommandExecutionCoordinator<C> {
        private final @Nullable ReentrantLock executionLock = Folia.FOLIA ? new ReentrantLock() : null;

        ExecutionCoordinator(CommandTree<C> commandTree) {
            super(commandTree);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CompletableFuture<CommandResult<C>> coordinateExecution(CommandContext<C> commandContext, Queue<String> input) {
            CompletableFuture<CommandResult<C>> completableFuture;
            block17: {
                completableFuture = new CompletableFuture<CommandResult<C>>();
                try {
                    Pair<@Nullable Command<C>, @Nullable Exception> pair = this.getCommandTree().parse(commandContext, input);
                    if (pair.getSecond() != null) {
                        completableFuture.completeExceptionally(pair.getSecond());
                        break block17;
                    }
                    Command command = Objects.requireNonNull(pair.getFirst());
                    if (this.getCommandTree().getCommandManager().postprocessContext(commandContext, command) == State.ACCEPTED) {
                        if (this.executionLock != null) {
                            this.executionLock.lock();
                        }
                        try {
                            command.getCommandExecutionHandler().executeFuture(commandContext).get();
                        }
                        catch (ExecutionException exception) {
                            Throwable cause = exception.getCause();
                            if (cause instanceof CommandExecutionException) {
                                completableFuture.completeExceptionally(cause);
                            } else {
                                completableFuture.completeExceptionally(new CommandExecutionException(cause, commandContext));
                            }
                        }
                        catch (CommandExecutionException exception) {
                            completableFuture.completeExceptionally(exception);
                        }
                        catch (Exception exception) {
                            completableFuture.completeExceptionally(new CommandExecutionException(exception, commandContext));
                        }
                        finally {
                            if (this.executionLock != null) {
                                this.executionLock.unlock();
                            }
                        }
                    }
                    completableFuture.complete(new CommandResult<C>(commandContext));
                }
                catch (Exception e) {
                    completableFuture.completeExceptionally(e);
                }
            }
            return completableFuture;
        }
    }
}

