/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.paper;

import io.papermc.paper.threadedregions.RegionizedServerInitEvent;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import org.bukkit.Server;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import squaremap.libraries.com.google.inject.Inject;
import squaremap.libraries.com.google.inject.Injector;
import squaremap.libraries.com.google.inject.Singleton;
import squaremap.libraries.org.bstats.bukkit.Metrics;
import xyz.jpenilla.squaremap.api.Squaremap;
import xyz.jpenilla.squaremap.common.SquaremapCommon;
import xyz.jpenilla.squaremap.common.SquaremapPlatform;
import xyz.jpenilla.squaremap.common.task.UpdatePlayers;
import xyz.jpenilla.squaremap.common.task.UpdateWorldData;
import xyz.jpenilla.squaremap.paper.listener.MapUpdateListeners;
import xyz.jpenilla.squaremap.paper.listener.WorldLoadListener;
import xyz.jpenilla.squaremap.paper.network.PaperNetworking;
import xyz.jpenilla.squaremap.paper.util.Folia;

@Singleton
public final class SquaremapPaper
implements SquaremapPlatform {
    private final Injector injector;
    private final SquaremapCommon common;
    private final PaperNetworking networking;
    private final JavaPlugin plugin;
    private final Server server;
    private @MonotonicNonNull Squaremap api;
    private @Nullable ScheduledTask updateWorldData;
    private @Nullable ScheduledTask updatePlayers;
    private @Nullable MapUpdateListeners mapUpdateListeners;
    private @Nullable WorldLoadListener worldLoadListener;

    @Inject
    private SquaremapPaper(Injector injector, SquaremapCommon squaremapCommon, Server server, JavaPlugin plugin, PaperNetworking networking) {
        this.injector = injector;
        this.common = squaremapCommon;
        this.server = server;
        this.plugin = plugin;
        this.networking = networking;
    }

    void init() {
        this.common.init();
        this.api = this.injector.getInstance(Squaremap.class);
        this.server.getServicesManager().register(Squaremap.class, (Object)this.api, (Plugin)this.plugin, ServicePriority.Normal);
        this.networking.register();
        new Metrics(this.plugin, 13571);
        if (Folia.FOLIA) {
            this.server.getPluginManager().registerEvents((Listener)new FoliaInitListener(), (Plugin)this.plugin);
        } else {
            this.server.getScheduler().runTask((Plugin)this.plugin, this.common::updateCheck);
        }
    }

    void onDisable() {
        this.networking.unregister();
        if (this.api != null) {
            this.server.getServicesManager().unregister(Squaremap.class, (Object)this.api);
        }
        this.common.shutdown();
    }

    @Override
    public void startCallback() {
        this.worldLoadListener = this.injector.getInstance(WorldLoadListener.class);
        this.server.getPluginManager().registerEvents((Listener)this.worldLoadListener, (Plugin)this.plugin);
        this.mapUpdateListeners = this.injector.getInstance(MapUpdateListeners.class);
        this.mapUpdateListeners.register();
        Runnable updatePlayersTask = this.injector.getInstance(UpdatePlayers.class);
        this.updatePlayers = this.server.getGlobalRegionScheduler().runAtFixedRate((Plugin)this.plugin, $ -> updatePlayersTask.run(), 20L, 20L);
        Runnable updateWorldDataTask = this.injector.getInstance(UpdateWorldData.class);
        this.updateWorldData = this.server.getGlobalRegionScheduler().runAtFixedRate((Plugin)this.plugin, $ -> updateWorldDataTask.run(), 1L, 100L);
    }

    @Override
    public void stopCallback() {
        if (this.updateWorldData != null) {
            this.updateWorldData.cancel();
            this.updateWorldData = null;
        }
        if (this.updatePlayers != null) {
            this.updatePlayers.cancel();
            this.updatePlayers = null;
        }
        if (this.mapUpdateListeners != null) {
            this.mapUpdateListeners.unregister();
            this.mapUpdateListeners = null;
        }
        if (this.worldLoadListener != null) {
            HandlerList.unregisterAll((Listener)this.worldLoadListener);
            this.worldLoadListener = null;
        }
    }

    @Override
    public @NonNull String version() {
        return this.plugin.getDescription().getVersion();
    }

    public final class FoliaInitListener
    implements Listener {
        @EventHandler
        public void handle(RegionizedServerInitEvent event) {
            SquaremapPaper.this.server.getAsyncScheduler().runNow((Plugin)SquaremapPaper.this.plugin, $ -> SquaremapPaper.this.common.updateCheck());
        }
    }
}

