/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.paper;

import java.util.Optional;
import net.minecraft.server.level.WorldServer;
import org.bukkit.World;
import squaremap.libraries.com.google.inject.Inject;
import squaremap.libraries.com.google.inject.Singleton;
import xyz.jpenilla.squaremap.common.ServerAccess;
import xyz.jpenilla.squaremap.common.WorldManagerImpl;
import xyz.jpenilla.squaremap.common.config.ConfigManager;
import xyz.jpenilla.squaremap.common.data.DirectoryProvider;
import xyz.jpenilla.squaremap.common.data.MapWorldInternal;
import xyz.jpenilla.squaremap.paper.util.CraftBukkitReflection;
import xyz.jpenilla.squaremap.paper.util.WorldNameToKeyMigration;

@Singleton
public final class PaperWorldManager
extends WorldManagerImpl {
    private final DirectoryProvider directoryProvider;

    @Inject
    private PaperWorldManager(MapWorldInternal.Factory factory, ServerAccess serverAccess, DirectoryProvider directoryProvider, ConfigManager configManager) {
        super(factory, serverAccess, configManager);
        this.directoryProvider = directoryProvider;
    }

    @Override
    public void initWorld(WorldServer level) {
        WorldNameToKeyMigration.tryMoveDirectories(this.directoryProvider, level);
        super.initWorld(level);
    }

    public Optional<MapWorldInternal> getWorldIfEnabled(World world) {
        return this.getWorldIfEnabled(CraftBukkitReflection.serverLevel(world));
    }
}

