/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.paper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import squaremap.libraries.com.google.inject.Inject;
import squaremap.libraries.com.google.inject.Singleton;
import xyz.jpenilla.squaremap.api.BukkitAdapter;
import xyz.jpenilla.squaremap.api.WorldIdentifier;
import xyz.jpenilla.squaremap.common.ServerAccess;
import xyz.jpenilla.squaremap.paper.util.CraftBukkitReflection;

@Singleton
public final class PaperServerAccess
implements ServerAccess {
    private final Server server;

    @Inject
    private PaperServerAccess(Server server) {
        this.server = server;
    }

    @Override
    public @NonNull Collection<WorldServer> levels() {
        ArrayList<WorldServer> levels = new ArrayList<WorldServer>();
        for (World world : this.server.getWorlds()) {
            levels.add(CraftBukkitReflection.serverLevel(world));
        }
        return levels;
    }

    @Override
    public @Nullable WorldServer level(@NonNull WorldIdentifier identifier) {
        @Nullable World world = this.server.getWorld(BukkitAdapter.namespacedKey(identifier));
        if (world == null) {
            return null;
        }
        return CraftBukkitReflection.serverLevel(world);
    }

    @Override
    public @Nullable EntityPlayer player(UUID uuid) {
        @Nullable Player player = this.server.getPlayer(uuid);
        if (player == null) {
            return null;
        }
        return CraftBukkitReflection.serverPlayer(player);
    }

    @Override
    public int maxPlayers() {
        return this.server.getMaxPlayers();
    }
}

