/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.paper;

import net.kyori.adventure.text.Component;
import net.minecraft.server.level.EntityPlayer;
import org.bukkit.NamespacedKey;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import squaremap.libraries.com.google.inject.Inject;
import squaremap.libraries.com.google.inject.Singleton;
import xyz.jpenilla.squaremap.common.AbstractPlayerManager;
import xyz.jpenilla.squaremap.common.ServerAccess;
import xyz.jpenilla.squaremap.paper.util.CraftBukkitReflection;

@Singleton
public final class PaperPlayerManager
extends AbstractPlayerManager {
    public final NamespacedKey hiddenKey;

    @Inject
    private PaperPlayerManager(JavaPlugin plugin, ServerAccess serverAccess) {
        super(serverAccess);
        this.hiddenKey = new NamespacedKey((Plugin)plugin, "hidden");
    }

    @Override
    protected boolean persistentHidden(EntityPlayer player) {
        return (Byte)PaperPlayerManager.pdc(player).getOrDefault(this.hiddenKey, PersistentDataType.BYTE, (Object)0) != 0;
    }

    @Override
    protected void persistentHidden(EntityPlayer player, boolean value) {
        PaperPlayerManager.pdc(player).set(this.hiddenKey, PersistentDataType.BYTE, (Object)((byte)(value ? 1 : 0)));
    }

    @Override
    public boolean otherwiseHidden(EntityPlayer player) {
        return CraftBukkitReflection.player(player).hasMetadata("NPC");
    }

    @Override
    public Component displayName(EntityPlayer player) {
        return CraftBukkitReflection.player(player).displayName();
    }

    private static PersistentDataContainer pdc(EntityPlayer player) {
        return CraftBukkitReflection.player(player).getPersistentDataContainer();
    }
}

