/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.visibilitylimit;

import net.minecraft.core.BlockPosition;
import net.minecraft.world.level.border.WorldBorder;
import xyz.jpenilla.squaremap.api.MapWorld;
import xyz.jpenilla.squaremap.common.data.MapWorldInternal;
import xyz.jpenilla.squaremap.common.util.Numbers;
import xyz.jpenilla.squaremap.common.visibilitylimit.VisibilityShape;

public final class WorldBorderShape
implements VisibilityShape {
    @Override
    public boolean shouldRenderChunk(MapWorld world, int chunkX, int chunkZ) {
        WorldBorder border = ((MapWorldInternal)world).serverLevel().B_();
        BlockPosition center = new BlockPosition((int)border.a(), 0, (int)border.b());
        int radius = (int)Math.ceil(border.i() / 2.0);
        if (chunkX < Numbers.blockToChunk(center.u() - radius) || chunkX > Numbers.blockToChunk(center.u() + radius)) {
            return false;
        }
        return chunkZ >= Numbers.blockToChunk(center.w() - radius) && chunkZ <= Numbers.blockToChunk(center.w() + radius);
    }

    @Override
    public boolean shouldRenderRegion(MapWorld world, int regionX, int regionZ) {
        WorldBorder border = ((MapWorldInternal)world).serverLevel().B_();
        BlockPosition center = new BlockPosition((int)border.a(), 0, (int)border.b());
        int radius = (int)Math.ceil(border.i() / 2.0);
        if (regionX < Numbers.blockToRegion(center.u() - radius) || regionX > Numbers.blockToRegion(center.u() + radius)) {
            return false;
        }
        return regionZ >= Numbers.blockToRegion(center.w() - radius) && regionZ <= Numbers.blockToRegion(center.w() + radius);
    }

    @Override
    public boolean shouldRenderColumn(MapWorld world, int blockX, int blockZ) {
        WorldBorder border = ((MapWorldInternal)world).serverLevel().B_();
        BlockPosition center = new BlockPosition((int)border.a(), 0, (int)border.b());
        int radius = (int)Math.ceil(border.i() / 2.0);
        if (blockX < center.u() - radius || blockX >= center.u() + radius) {
            return false;
        }
        return blockZ >= center.w() - radius && blockZ < center.w() + radius;
    }

    @Override
    public int countChunksInRegion(MapWorld world, int regionX, int regionZ) {
        WorldBorder border = ((MapWorldInternal)world).serverLevel().B_();
        int regionMinChunkX = Numbers.regionToChunk(regionX);
        int regionMaxChunkX = Numbers.regionToChunk(regionX + 1) - 1;
        int regionMinChunkZ = Numbers.regionToChunk(regionZ);
        int regionMaxChunkZ = Numbers.regionToChunk(regionZ + 1) - 1;
        BlockPosition center = new BlockPosition((int)border.a(), 0, (int)border.b());
        int radius = (int)Math.ceil(border.i() / 2.0);
        int borderMinChunkX = Numbers.blockToChunk(center.u() - radius);
        int borderMaxChunkX = Numbers.blockToChunk(center.u() + radius);
        int borderMinChunkZ = Numbers.blockToChunk(center.w() - radius);
        int borderMaxChunkZ = Numbers.blockToChunk(center.w() + radius);
        int chunkWidth = Math.min(regionMaxChunkX, borderMaxChunkX) - Math.max(regionMinChunkX, borderMinChunkX) + 1;
        int chunkHeight = Math.min(regionMaxChunkZ, borderMaxChunkZ) - Math.max(regionMinChunkZ, borderMinChunkZ) + 1;
        if (chunkWidth < 0 || chunkHeight < 0) {
            return 0;
        }
        return chunkWidth * chunkHeight;
    }
}

