/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.visibilitylimit;

import java.util.List;
import xyz.jpenilla.squaremap.api.MapWorld;
import xyz.jpenilla.squaremap.api.Point;
import xyz.jpenilla.squaremap.common.util.Numbers;
import xyz.jpenilla.squaremap.common.visibilitylimit.VisibilityShape;

final class PolygonShape
implements VisibilityShape {
    private final List<Point> points;
    private final Bounds bounds;

    public PolygonShape(List<Point> points) {
        this.points = points;
        this.bounds = PolygonShape.calculateBounds(points);
    }

    @Override
    public boolean shouldRenderChunk(MapWorld world, int chunkX, int chunkZ) {
        int minX = Numbers.chunkToBlock(chunkX);
        int minZ = Numbers.chunkToBlock(chunkZ);
        int maxX = minX + 16;
        int maxZ = minZ + 16;
        for (int x = minX; x < maxX; ++x) {
            for (int z = minZ; z < maxZ; ++z) {
                if (!this.contains(x, z)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean shouldRenderRegion(MapWorld world, int regionX, int regionZ) {
        int minX = Numbers.regionToChunk(regionX);
        int minZ = Numbers.regionToChunk(regionZ);
        int maxX = minX + 32;
        int maxZ = minZ + 32;
        for (int x = minX; x < maxX; ++x) {
            for (int z = minZ; z < maxZ; ++z) {
                if (!this.shouldRenderChunk(world, x, z)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean shouldRenderColumn(MapWorld world, int blockX, int blockZ) {
        return this.contains(blockX, blockZ);
    }

    @Override
    public int countChunksInRegion(MapWorld world, int regionX, int regionZ) {
        int minX = Numbers.regionToChunk(regionX);
        int minZ = Numbers.regionToChunk(regionZ);
        int maxX = minX + 32;
        int maxZ = minZ + 32;
        int count = 0;
        for (int x = minX; x < maxX; ++x) {
            for (int z = minZ; z < maxZ; ++z) {
                if (!this.shouldRenderChunk(world, x, z)) continue;
                ++count;
            }
        }
        return count;
    }

    /*
     * Unable to fully structure code
     */
    private boolean contains(double x, double y) {
        npoints = this.points.size();
        if (npoints <= 2 || !this.bounds.contains(x, y)) {
            return false;
        }
        hits = 0;
        lastx = (int)this.points.get(npoints - 1).x();
        lasty = (int)this.points.get(npoints - 1).z();
        for (i = 0; i < npoints; ++i) {
            block8: {
                block11: {
                    block12: {
                        block10: {
                            block9: {
                                curx = (int)this.points.get(i).x();
                                cury = (int)this.points.get(i).z();
                                if (cury == lasty) break block8;
                                if (curx >= lastx) break block9;
                                if (x >= (double)lastx) break block8;
                                leftx = curx;
                                break block10;
                            }
                            if (x >= (double)curx) break block8;
                            leftx = lastx;
                        }
                        if (cury >= lasty) break block11;
                        if (y < (double)cury || y >= (double)lasty) break block8;
                        if (!(x < (double)leftx)) break block12;
                        ++hits;
                        break block8;
                    }
                    test1 = x - (double)curx;
                    test2 = y - (double)cury;
                    ** GOTO lbl35
                }
                if (y < (double)lasty || y >= (double)cury) break block8;
                if (x < (double)leftx) {
                    ++hits;
                } else {
                    test1 = x - (double)lastx;
                    test2 = y - (double)lasty;
lbl35:
                    // 2 sources

                    if (test1 < test2 / (double)(lasty - cury) * (double)(lastx - curx)) {
                        ++hits;
                    }
                }
            }
            lastx = curx;
            lasty = cury;
        }
        return (hits & true) != false;
    }

    private static Bounds calculateBounds(List<Point> points) {
        int boundsMinX = Integer.MAX_VALUE;
        int boundsMinY = Integer.MAX_VALUE;
        int boundsMaxX = Integer.MIN_VALUE;
        int boundsMaxY = Integer.MIN_VALUE;
        for (Point p : points) {
            int x = (int)p.x();
            boundsMinX = Math.min(boundsMinX, x);
            boundsMaxX = Math.max(boundsMaxX, x);
            int y = (int)p.z();
            boundsMinY = Math.min(boundsMinY, y);
            boundsMaxY = Math.max(boundsMaxY, y);
        }
        return new Bounds(boundsMinX, boundsMinY, boundsMaxX - boundsMinX, boundsMaxY - boundsMinY);
    }

    private record Bounds(int x, int y, int width, int height) {
        public boolean contains(double x, double y) {
            double x0 = this.x;
            double y0 = this.y;
            return x >= x0 && y >= y0 && x < x0 + (double)this.width && y < y0 + (double)this.height;
        }
    }
}

