/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.visibilitylimit;

import xyz.jpenilla.squaremap.api.MapWorld;
import xyz.jpenilla.squaremap.common.util.Numbers;
import xyz.jpenilla.squaremap.common.visibilitylimit.VisibilityShape;

final class CircleShape
implements VisibilityShape {
    private static final int REGION_SIZE_BLOCKS = Numbers.regionToBlock(1);
    private static final int CHUNK_SIZE_BLOCKS = Numbers.chunkToBlock(1);
    private static final int REGION_SIZE_CHUNKS = Numbers.regionToChunk(1);
    private final int centerX;
    private final int centerZ;
    private final int radius;
    private final int radiusSquared;

    public CircleShape(int centerX, int centerZ, int radius) {
        if (radius < 1) {
            throw new IllegalArgumentException("Radius must be positive, but was " + radius);
        }
        this.centerX = centerX;
        this.centerZ = centerZ;
        this.radius = radius;
        this.radiusSquared = radius * radius;
    }

    @Override
    public boolean shouldRenderChunk(MapWorld world, int chunkX, int chunkZ) {
        long distanceSquared;
        if (this.radius == 0) {
            return false;
        }
        long blockX = Numbers.chunkToBlock(chunkX);
        long blockZ = Numbers.chunkToBlock(chunkZ);
        if (blockX < (long)this.centerX) {
            blockX += Math.min((long)(CHUNK_SIZE_BLOCKS - 1), (long)this.centerX - blockX);
        }
        if (blockZ < (long)this.centerZ) {
            blockZ += Math.min((long)(CHUNK_SIZE_BLOCKS - 1), (long)this.centerZ - blockZ);
        }
        return (distanceSquared = (blockX - (long)this.centerX) * (blockX - (long)this.centerX) + (blockZ - (long)this.centerZ) * (blockZ - (long)this.centerZ)) <= (long)this.radiusSquared;
    }

    @Override
    public boolean shouldRenderRegion(MapWorld world, int regionX, int regionZ) {
        long distanceSquared;
        if (this.radius == 0) {
            return false;
        }
        long blockX = Numbers.regionToBlock(regionX);
        long blockZ = Numbers.regionToBlock(regionZ);
        if (blockX < (long)this.centerX) {
            blockX += Math.min((long)(REGION_SIZE_BLOCKS - 1), (long)this.centerX - blockX);
        }
        if (blockZ < (long)this.centerZ) {
            blockZ += Math.min((long)(REGION_SIZE_BLOCKS - 1), (long)this.centerZ - blockZ);
        }
        return (distanceSquared = (blockX - (long)this.centerX) * (blockX - (long)this.centerX) + (blockZ - (long)this.centerZ) * (blockZ - (long)this.centerZ)) <= (long)this.radiusSquared;
    }

    @Override
    public boolean shouldRenderColumn(MapWorld world, int blockX, int blockZ) {
        if (this.radius == 0) {
            return false;
        }
        long distanceSquared = (long)(blockX - this.centerX) * (long)(blockX - this.centerX) + (long)(blockZ - this.centerZ) * (long)(blockZ - this.centerZ);
        return distanceSquared <= (long)this.radiusSquared;
    }

    @Override
    public int countChunksInRegion(MapWorld world, int regionX, int regionZ) {
        int chunkZStart;
        int chunkXStart = Numbers.regionToChunk(regionX);
        if (this.shouldRenderChunk(world, chunkXStart, chunkZStart = Numbers.regionToChunk(regionZ)) && this.shouldRenderChunk(world, chunkXStart + REGION_SIZE_CHUNKS - 1, chunkZStart) && this.shouldRenderChunk(world, chunkXStart, chunkZStart + REGION_SIZE_CHUNKS - 1) && this.shouldRenderChunk(world, chunkXStart + REGION_SIZE_CHUNKS - 1, chunkZStart + REGION_SIZE_CHUNKS - 1)) {
            return REGION_SIZE_CHUNKS * REGION_SIZE_CHUNKS;
        }
        int count = 0;
        for (int i = 0; i < REGION_SIZE_CHUNKS; ++i) {
            for (int j = 0; j < REGION_SIZE_CHUNKS; ++j) {
                if (!this.shouldRenderChunk(world, chunkXStart + i, chunkZStart + j)) continue;
                ++count;
            }
        }
        return count;
    }
}

