/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.util.chunksnapshot;

import com.mojang.datafixers.util.Either;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunkExtension;
import org.checkerframework.checker.nullness.qual.Nullable;
import xyz.jpenilla.squaremap.common.util.ChunkMapAccess;
import xyz.jpenilla.squaremap.common.util.chunksnapshot.ChunkSnapshot;
import xyz.jpenilla.squaremap.common.util.chunksnapshot.ChunkSnapshotProvider;

record VanillaChunkSnapshotProvider(WorldServer level) implements ChunkSnapshotProvider
{
    private static final MinecraftKey FULL = BuiltInRegistries.o.b((Object)ChunkStatus.n);

    @Override
    public CompletableFuture<@Nullable ChunkSnapshot> asyncSnapshot(int x, int z) {
        return CompletableFuture.supplyAsync(() -> {
            @Nullable IChunkAccess chunk = VanillaChunkSnapshotProvider.chunkIfGenerated(this.level, x, z);
            if (chunk == null) {
                return null;
            }
            return ChunkSnapshot.snapshot((World)this.level, chunk, false);
        }, (Executor)this.level.n());
    }

    private static @Nullable IChunkAccess chunkIfGenerated(WorldServer level, int x, int z) {
        IChunkAccess chunk;
        IChunkAccess chunk2;
        ChunkMapAccess chunkMap = (ChunkMapAccess)level.k().a;
        ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(x, z);
        PlayerChunk visibleChunk = chunkMap.squaremap$getVisibleChunkIfPresent(chunkPos.a());
        if (visibleChunk != null && (chunk2 = VanillaChunkSnapshotProvider.fullIfPresent(visibleChunk)) != null) {
            return chunk2;
        }
        PlayerChunk unloadingChunk = (PlayerChunk)chunkMap.squaremap$pendingUnloads().get(chunkPos.a());
        if (unloadingChunk != null && (chunk = VanillaChunkSnapshotProvider.fullIfPresent(unloadingChunk)) != null) {
            return chunk;
        }
        @Nullable NBTTagCompound chunkTag = chunkMap.squaremap$readChunk(chunkPos).join().orElse(null);
        if (chunkTag != null && chunkTag.b("Status", 8) && (VanillaChunkSnapshotProvider.isFullStatus(chunkTag) || VanillaChunkSnapshotProvider.preHeightChangeFullChunk(chunkTag))) {
            @Nullable IChunkAccess chunk3 = ((Either)level.k().b(x, z, ChunkStatus.c, true).join()).left().orElse(null);
            return VanillaChunkSnapshotProvider.unwrap(chunk3);
        }
        return null;
    }

    private static boolean isFullStatus(NBTTagCompound chunkTag) {
        return FULL.equals((Object)MinecraftKey.a((String)chunkTag.l("Status")));
    }

    private static @Nullable IChunkAccess fullIfPresent(PlayerChunk chunkHolder) {
        return VanillaChunkSnapshotProvider.unwrap(chunkHolder.i());
    }

    private static @Nullable IChunkAccess unwrap(@Nullable IChunkAccess chunk) {
        if (chunk == null) {
            return null;
        }
        if (chunk instanceof ProtoChunkExtension) {
            ProtoChunkExtension imposter = (ProtoChunkExtension)chunk;
            chunk = imposter.C();
        }
        if (!chunk.j().b(ChunkStatus.n) && !VanillaChunkSnapshotProvider.preHeightChangeFullChunk(chunk)) {
            return null;
        }
        return chunk;
    }

    private static boolean preHeightChangeFullChunk(IChunkAccess chunk) {
        return chunk.x() != null && chunk.x().a().b(ChunkStatus.m);
    }

    private static boolean preHeightChangeFullChunk(NBTTagCompound chunkTag) {
        NBTTagCompound belowZeroRetrogen = chunkTag.p("below_zero_retrogen");
        if (belowZeroRetrogen.g()) {
            return false;
        }
        String targetStatusStr = belowZeroRetrogen.l("target_status");
        if (targetStatusStr.isEmpty()) {
            return false;
        }
        @Nullable MinecraftKey targetStatus = MinecraftKey.a((String)targetStatusStr);
        if (targetStatus == null) {
            return false;
        }
        return ((ChunkStatus)BuiltInRegistries.o.a(targetStatus)).b(ChunkStatus.m);
    }
}

