/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.util.chunksnapshot;

import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import xyz.jpenilla.squaremap.common.util.chunksnapshot.ChunkSnapshot;
import xyz.jpenilla.squaremap.common.util.chunksnapshot.HeightmapSnapshot;

record ChunkSnapshotImpl(LevelHeightAccessor heightAccessor, DataPaletteBlock<IBlockData>[] states, DataPaletteBlock<Holder<BiomeBase>>[] biomes, Map<HeightMap.Type, HeightmapSnapshot> heightmaps, boolean[] emptySections, DimensionManager dimensionType, ChunkCoordIntPair pos) implements ChunkSnapshot
{
    static final DataPaletteBlock<IBlockData> EMPTY_SECTION_BLOCK_STATES = new DataPaletteBlock((Registry)Block.o, (Object)Blocks.a.n(), DataPaletteBlock.d.d);
    static final EnumMap<HeightMap.Type, HeightmapSnapshot> EMPTY_HEIGHTMAPS = new EnumMap(HeightMap.Type.class);

    @Override
    public IBlockData getBlockState(BlockPosition pos) {
        return this.getBlockState(pos.u(), pos.v(), pos.w());
    }

    private IBlockData getBlockState(int x, int y, int z) {
        int sectionIndex = this.e(y);
        if (sectionIndex < 0 || sectionIndex >= this.states.length || this.sectionEmpty(sectionIndex)) {
            return Blocks.a.n();
        }
        return (IBlockData)this.states[sectionIndex].a((y & 0xF) << 8 | (z & 0xF) << 4 | x & 0xF);
    }

    @Override
    public Fluid getFluidState(BlockPosition pos) {
        return this.getFluidState(pos.u(), pos.v(), pos.w());
    }

    private Fluid getFluidState(int x, int y, int z) {
        int sectionIndex = this.e(y);
        if (sectionIndex < 0 || sectionIndex >= this.states.length || this.sectionEmpty(sectionIndex)) {
            return FluidTypes.a.g();
        }
        return ((IBlockData)this.states[sectionIndex].a((y & 0xF) << 8 | (z & 0xF) << 4 | x & 0xF)).u();
    }

    @Override
    public int getHeight(HeightMap.Type type, int x, int z) {
        HeightmapSnapshot heightmap = this.heightmaps.get(type);
        if (heightmap == null) {
            throw new RuntimeException("Missing heightmaps " + type);
        }
        return heightmap.getFirstAvailable(x & 0xF, z & 0xF) - 1;
    }

    public int I_() {
        return this.heightAccessor.I_();
    }

    public int H_() {
        return this.heightAccessor.H_();
    }

    @Override
    public boolean sectionEmpty(int sectionIndex) {
        return this.emptySections[sectionIndex];
    }

    public Holder<BiomeBase> getNoiseBiome(int quartX, int quartY, int quartZ) {
        int minQuartY = QuartPos.a((int)this.H_());
        int maxQuartY = minQuartY + QuartPos.a((int)this.I_()) - 1;
        int clampedQuartY = MathHelper.a((int)quartY, (int)minQuartY, (int)maxQuartY);
        int sectionIndex = this.e(QuartPos.c((int)clampedQuartY));
        return (Holder)this.biomes[sectionIndex].a(quartX & 3, clampedQuartY & 3, quartZ & 3);
    }
}

