/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.util.chunksnapshot;

import java.util.EnumMap;
import java.util.Set;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.material.Fluid;
import xyz.jpenilla.squaremap.common.util.chunksnapshot.ChunkSnapshotImpl;
import xyz.jpenilla.squaremap.common.util.chunksnapshot.HeightmapSnapshot;

public interface ChunkSnapshot
extends LevelHeightAccessor,
BiomeManager.Provider {
    public IBlockData getBlockState(BlockPosition var1);

    public Fluid getFluidState(BlockPosition var1);

    public int getHeight(HeightMap.Type var1, int var2, int var3);

    public DimensionManager dimensionType();

    public ChunkCoordIntPair pos();

    public boolean sectionEmpty(int var1);

    public static ChunkSnapshot snapshot(World level, IChunkAccess chunk, boolean biomesOnly) {
        LevelHeightAccessor heightAccessor = LevelHeightAccessor.e((int)chunk.H_(), (int)chunk.I_());
        int sectionCount = heightAccessor.ak();
        ChunkSection[] sections = chunk.d();
        DataPaletteBlock[] states = new DataPaletteBlock[sectionCount];
        DataPaletteBlock[] biomes = new DataPaletteBlock[sectionCount];
        boolean[] empty = new boolean[sectionCount];
        EnumMap<HeightMap.Type, HeightmapSnapshot> heightmaps = ChunkSnapshotImpl.EMPTY_HEIGHTMAPS;
        if (!biomesOnly) {
            if (!chunk.b(HeightMap.Type.b)) {
                if (chunk.x() == null) {
                    throw new IllegalStateException("Expected WORLD_SURFACE heightmap to be present, but it wasn't! " + chunk.f());
                }
                HeightMap.a((IChunkAccess)chunk, Set.of(HeightMap.Type.b));
            }
            heightmaps = new EnumMap<HeightMap.Type, HeightmapSnapshot>(ChunkSnapshotImpl.EMPTY_HEIGHTMAPS);
            heightmaps.put(HeightMap.Type.b, new HeightmapSnapshot(chunk, heightAccessor, HeightMap.Type.b));
            for (int i = 0; i < sectionCount; ++i) {
                boolean sectionEmpty;
                empty[i] = sectionEmpty = sections[i].c();
                states[i] = sectionEmpty ? ChunkSnapshotImpl.EMPTY_SECTION_BLOCK_STATES : sections[i].h().d();
                biomes[i] = ((DataPaletteBlock)sections[i].i()).d();
            }
        } else {
            for (int i = 0; i < sectionCount; ++i) {
                biomes[i] = ((DataPaletteBlock)sections[i].i()).d();
            }
        }
        return new ChunkSnapshotImpl(heightAccessor, states, biomes, heightmaps, empty, level.C_(), chunk.f());
    }
}

