/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.jar.Manifest;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.ICombinedAccess;
import net.minecraft.world.level.biome.BiomeBase;
import org.checkerframework.checker.nullness.qual.Nullable;
import xyz.jpenilla.squaremap.api.WorldIdentifier;
import xyz.jpenilla.squaremap.common.util.CheckedConsumer;
import xyz.jpenilla.squaremap.common.util.NamedThreadFactory;
import xyz.jpenilla.squaremap.common.util.RecordTypeAdapterFactory;

public final class Util {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new RecordTypeAdapterFactory()).create();

    private Util() {
    }

    public static Gson gson() {
        return GSON;
    }

    public static <X extends Throwable> RuntimeException rethrow(Throwable t) throws X {
        throw t;
    }

    public static <T, X extends Throwable> Consumer<T> sneaky(CheckedConsumer<T, X> consumer) {
        return t -> {
            try {
                consumer.accept(t);
            }
            catch (Throwable thr) {
                Util.rethrow(thr);
            }
        };
    }

    public static ThreadFactory squaremapThreadFactory(String name) {
        return new NamedThreadFactory("squaremap-" + name);
    }

    public static ThreadFactory squaremapThreadFactory(String name, WorldServer level) {
        return Util.squaremapThreadFactory(name + "-[" + level.ac().a() + "]");
    }

    public static ThreadPoolExecutor newFixedThreadPool(int size, ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        return new ThreadPoolExecutor(size, size, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory, rejectedExecutionHandler);
    }

    public static void shutdownExecutor(ExecutorService service, TimeUnit timeoutUnit, long timeoutLength) {
        boolean didShutdown;
        service.shutdown();
        try {
            didShutdown = service.awaitTermination(timeoutLength, timeoutUnit);
        }
        catch (InterruptedException ignore) {
            didShutdown = false;
        }
        if (!didShutdown) {
            service.shutdownNow();
        }
    }

    public static <T> T requireEntry(IRegistry<T> registry, MinecraftKey location) {
        if (!registry.c(location)) {
            throw new IllegalArgumentException("No such entry '" + location + "' in registry '" + registry.c() + "'");
        }
        return (T)Objects.requireNonNull(registry.a(location));
    }

    public static String levelConfigName(WorldServer level) {
        return level.ac().a().toString();
    }

    public static String levelWebName(WorldServer level) {
        return level.ac().a().toString().replace(":", "_");
    }

    public static WorldIdentifier worldIdentifier(WorldServer level) {
        MinecraftKey location = level.ac().a();
        return Util.worldIdentifier(location);
    }

    public static WorldIdentifier worldIdentifier(MinecraftKey location) {
        return WorldIdentifier.create(location.b(), location.a());
    }

    public static byte[] raw(PacketDataSerializer buf) {
        byte[] data = new byte[buf.readableBytes()];
        buf.b(data);
        return data;
    }

    public static IRegistry<BiomeBase> biomeRegistry(ICombinedAccess level) {
        return Util.biomeRegistry(level.G_());
    }

    public static IRegistry<BiomeBase> biomeRegistry(IRegistryCustom registryAccess) {
        return registryAccess.d(Registries.ap);
    }

    public static @Nullable Manifest manifest(Class<?> clazz) {
        Manifest manifest;
        block9: {
            String classLocation = "/" + clazz.getName().replace(".", "/") + ".class";
            @Nullable URL resource = clazz.getResource(classLocation);
            if (resource == null) {
                return null;
            }
            String classFilePath = resource.toString().replace("\\", "/");
            String archivePath = classFilePath.substring(0, classFilePath.length() - classLocation.length());
            InputStream stream = new URL(archivePath + "/META-INF/MANIFEST.MF").openStream();
            try {
                manifest = new Manifest(stream);
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    return null;
                }
            }
            stream.close();
        }
        return manifest;
    }
}

