/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.util;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import squaremap.libraries.com.google.inject.Inject;
import xyz.jpenilla.squaremap.common.Logging;
import xyz.jpenilla.squaremap.common.util.CheckedConsumer;
import xyz.jpenilla.squaremap.common.util.FileUtil;

public interface SquaremapJarAccess {
    public void useJar(CheckedConsumer<Path, IOException> var1) throws IOException, URISyntaxException;

    default public void extract(String inDir, Path outDir, boolean replaceExisting) {
        try {
            this.useJar(root -> FileUtil.specialCopyRecursively(root.resolve(inDir), outDir, replaceExisting));
        }
        catch (IOException | URISyntaxException ex) {
            Logging.logger().error("Failed to extract directory '{}' from jar to '{}'", (Object)inDir, (Object)outDir, (Object)ex);
        }
    }

    public static final class JarFromCodeSource
    implements SquaremapJarAccess {
        @Inject
        private JarFromCodeSource() {
        }

        @Override
        public void useJar(CheckedConsumer<Path, IOException> consumer) throws IOException, URISyntaxException {
            FileUtil.openJar(JarFromCodeSource.jar(), fileSystem -> consumer.accept(fileSystem.getPath("/", new String[0])));
        }

        private static Path jar() throws URISyntaxException, IOException {
            int exclamationIdx;
            URL sourceUrl = JarFromCodeSource.class.getProtectionDomain().getCodeSource().getLocation();
            if (sourceUrl.getProtocol().equals("jar") && (exclamationIdx = sourceUrl.getPath().lastIndexOf(33)) != -1) {
                sourceUrl = new URL(sourceUrl.getPath().substring(0, exclamationIdx));
            }
            return Paths.get(sourceUrl.toURI());
        }
    }
}

