/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.util;

import java.util.Iterator;
import xyz.jpenilla.squaremap.common.data.ChunkCoordinate;
import xyz.jpenilla.squaremap.common.data.RegionCoordinate;

public final class SpiralIterator<T>
implements Iterator<T> {
    private final long totalSteps;
    private final CoordinateMapper<T> coordinateMapper;
    private int x;
    private int z;
    private long legAxis;
    private long stepCount;
    private long stepLeg;
    private long layer;
    private Direction direction = Direction.RIGHT;

    private SpiralIterator(CoordinateMapper<T> coordinateMapper, int x, int z, int radius) {
        this.coordinateMapper = coordinateMapper;
        this.x = x;
        this.z = z;
        this.totalSteps = ((long)radius * 2L + 1L) * ((long)radius * 2L + 1L);
    }

    @Override
    public boolean hasNext() {
        return this.stepCount < this.totalSteps;
    }

    @Override
    public T next() {
        T t = this.coordinateMapper.create(this.x, this.z);
        if (!this.hasNext()) {
            return t;
        }
        switch (this.direction) {
            case DOWN: {
                ++this.z;
                break;
            }
            case LEFT: {
                --this.x;
                break;
            }
            case UP: {
                --this.z;
                break;
            }
            case RIGHT: {
                ++this.x;
            }
        }
        ++this.stepCount;
        ++this.stepLeg;
        if (this.stepLeg > this.layer) {
            this.direction = this.direction.next();
            this.stepLeg = 0L;
            ++this.legAxis;
            if (this.legAxis > 1L) {
                this.legAxis = 0L;
                ++this.layer;
            }
        }
        return t;
    }

    public static <T> Iterator<T> create(CoordinateMapper<T> coordinateMapper, int x, int z, int radius) {
        return new SpiralIterator<T>(coordinateMapper, x, z, radius);
    }

    public static Iterator<ChunkCoordinate> chunk(int x, int z, int radius) {
        return SpiralIterator.create(ChunkCoordinate::new, x, z, radius);
    }

    public static Iterator<RegionCoordinate> region(int x, int z, int radius) {
        return SpiralIterator.create(RegionCoordinate::new, x, z, radius);
    }

    private static enum Direction {
        RIGHT,
        DOWN,
        LEFT,
        UP;

        private static final Direction[] VALUES;

        public Direction next() {
            return VALUES[(this.ordinal() + 1) % VALUES.length];
        }

        static {
            VALUES = Direction.values();
        }
    }

    @FunctionalInterface
    public static interface CoordinateMapper<T> {
        public T create(int var1, int var2);
    }
}

