/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.util;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.RecordComponent;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RecordTypeAdapterFactory
implements TypeAdapterFactory {
    private static final Map<Class<?>, Object> PRIMITIVE_DEFAULTS = new HashMap();
    private final Map<RecordComponent, List<String>> recordComponentNameCache = new ConcurrentHashMap<RecordComponent, List<String>>();

    private List<String> getRecordComponentNames(RecordComponent recordComponent) {
        List<String> inCache = this.recordComponentNameCache.get(recordComponent);
        if (inCache != null) {
            return inCache;
        }
        ArrayList<String> names = new ArrayList<String>();
        SerializedName annotation = null;
        for (Annotation a : recordComponent.getAccessor().getAnnotations()) {
            if (a.annotationType() != SerializedName.class) continue;
            annotation = (SerializedName)a;
            break;
        }
        if (annotation != null) {
            names.add(annotation.value());
            names.addAll(Arrays.asList(annotation.alternate()));
        } else {
            names.add(recordComponent.getName());
        }
        List<String> namesList = List.copyOf(names);
        this.recordComponentNameCache.put(recordComponent, namesList);
        return namesList;
    }

    public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
        final Class clazz = type.getRawType();
        if (!clazz.isRecord()) {
            return null;
        }
        final TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
        return new TypeAdapter<T>(){

            public void write(JsonWriter out, T value) throws IOException {
                delegate.write(out, value);
            }

            public T read(JsonReader reader) throws IOException {
                if (reader.peek() == JsonToken.NULL) {
                    reader.nextNull();
                    return null;
                }
                RecordComponent[] recordComponents = clazz.getRecordComponents();
                HashMap<String, TypeToken> typeMap = new HashMap<String, TypeToken>();
                for (RecordComponent recordComponent : recordComponents) {
                    for (String name : RecordTypeAdapterFactory.this.getRecordComponentNames(recordComponent)) {
                        typeMap.put(name, TypeToken.get((Type)recordComponent.getGenericType()));
                    }
                }
                HashMap<String, Object> argsMap = new HashMap<String, Object>();
                reader.beginObject();
                while (reader.hasNext()) {
                    String name = reader.nextName();
                    TypeToken type = (TypeToken)typeMap.get(name);
                    if (type != null) {
                        argsMap.put(name, gson.getAdapter(type).read(reader));
                        continue;
                    }
                    gson.getAdapter(Object.class).read(reader);
                }
                reader.endObject();
                Class[] argTypes = new Class[recordComponents.length];
                Object[] args = new Object[recordComponents.length];
                for (int i = 0; i < recordComponents.length; ++i) {
                    argTypes[i] = recordComponents[i].getType();
                    List<String> names = RecordTypeAdapterFactory.this.getRecordComponentNames(recordComponents[i]);
                    Object value = null;
                    TypeToken type = null;
                    for (String name : names) {
                        value = argsMap.get(name);
                        type = (TypeToken)typeMap.get(name);
                        if (value == null || type == null) continue;
                        break;
                    }
                    if (value == null && type != null && type.getRawType().isPrimitive()) {
                        value = PRIMITIVE_DEFAULTS.get(type.getRawType());
                    }
                    args[i] = value;
                }
                try {
                    Constructor constructor = clazz.getDeclaredConstructor(argTypes);
                    constructor.setAccessible(true);
                    return constructor.newInstance(args);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    static {
        PRIMITIVE_DEFAULTS.put(Byte.TYPE, (byte)0);
        PRIMITIVE_DEFAULTS.put(Integer.TYPE, 0);
        PRIMITIVE_DEFAULTS.put(Long.TYPE, 0L);
        PRIMITIVE_DEFAULTS.put(Short.TYPE, (short)0);
        PRIMITIVE_DEFAULTS.put(Double.TYPE, 0.0);
        PRIMITIVE_DEFAULTS.put(Float.TYPE, Float.valueOf(0.0f));
        PRIMITIVE_DEFAULTS.put(Character.TYPE, Character.valueOf('\u0000'));
        PRIMITIVE_DEFAULTS.put(Boolean.TYPE, false);
    }
}

