/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import net.minecraft.server.level.WorldServer;
import xyz.jpenilla.squaremap.common.data.Image;
import xyz.jpenilla.squaremap.common.util.Util;

public final class ImageIOExecutor {
    private static final int IMAGE_IO_MAX_TASKS = 100;
    private final ExecutorService executor;
    private final AtomicLong submittedTasks = new AtomicLong();
    private final AtomicLong executedTasks = new AtomicLong();

    private ImageIOExecutor(WorldServer level) {
        this.executor = Executors.newSingleThreadExecutor(Util.squaremapThreadFactory("imageio", level));
    }

    public void saveImage(Image image) {
        this.submittedTasks.getAndIncrement();
        this.executor.execute(() -> {
            try {
                image.save();
            }
            finally {
                this.executedTasks.getAndIncrement();
            }
        });
        long executed = this.executedTasks.get();
        long submitted = this.submittedTasks.get();
        int failures = 1;
        while (submitted - executed >= 100L) {
            boolean interrupted = Thread.interrupted();
            Thread.yield();
            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(Math.min(25, failures)));
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            executed = this.executedTasks.get();
            submitted = this.submittedTasks.get();
            ++failures;
        }
    }

    public void shutdown() {
        Util.shutdownExecutor(this.executor, TimeUnit.SECONDS, 5L);
    }

    public static ImageIOExecutor create(WorldServer level) {
        return new ImageIOExecutor(level);
    }
}

