/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.util;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.ThreadLocalRandom;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.flattener.ComponentFlattener;
import net.kyori.adventure.text.flattener.FlattenerListener;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.format.TextFormat;
import org.checkerframework.checker.nullness.qual.Nullable;
import squaremap.libraries.org.owasp.html.PolicyFactory;
import squaremap.libraries.org.owasp.html.Sanitizers;
import xyz.jpenilla.squaremap.api.HtmlComponentSerializer;

final class HtmlComponentSerializerImpl
implements HtmlComponentSerializer {
    private static final PolicyFactory SANITIZER = Sanitizers.STYLES.and(Sanitizers.FORMATTING);
    private final ComponentFlattener flattener;

    HtmlComponentSerializerImpl(ComponentFlattener flattener) {
        this.flattener = flattener;
    }

    public String serialize(Component componentLike) {
        HtmlFlattener state = new HtmlFlattener();
        this.flattener.flatten(componentLike.asComponent(), (FlattenerListener)state);
        return SANITIZER.sanitize(state.toString());
    }

    private static final class HtmlFlattener
    implements FlattenerListener {
        private static final char[] OBFUSCATED_CHARS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
        private static final String CLOSE_SPAN = "</span>";
        private final StringBuilder sb = new StringBuilder();
        private final Deque<Style> stack = new ArrayDeque<Style>();

        private HtmlFlattener() {
        }

        public void pushStyle(Style style) {
            this.stack.push(style);
        }

        public void component(String text) {
            Style style = this.stack.stream().reduce(Style.empty(), Style::merge);
            int i = this.append(style);
            if (style.decorations().get(TextDecoration.OBFUSCATED) == TextDecoration.State.TRUE) {
                text.codePoints().forEach($ -> this.sb.append(OBFUSCATED_CHARS[ThreadLocalRandom.current().nextInt(OBFUSCATED_CHARS.length)]));
            } else {
                this.sb.append(text);
            }
            this.close(i);
        }

        public void popStyle(Style style) {
            this.stack.removeLastOccurrence(style);
        }

        private void append(TextFormat format) {
            this.sb.append(HtmlFlattener.asHtml(format));
        }

        private void close(int i) {
            for (int index = 0; index < i; ++index) {
                this.sb.append(CLOSE_SPAN);
            }
        }

        private int append(Style style) {
            int[] opened = new int[]{0};
            @Nullable TextColor color = style.color();
            if (color != null) {
                this.append((TextFormat)color);
                opened[0] = opened[0] + 1;
            }
            style.decorations().forEach((decoration, state) -> {
                if (decoration == TextDecoration.OBFUSCATED) {
                    return;
                }
                if (state == TextDecoration.State.TRUE) {
                    this.append((TextFormat)decoration);
                    opened[0] = opened[0] + 1;
                }
            });
            return opened[0];
        }

        public String toString() {
            return this.sb.toString();
        }

        private static String asHtml(TextFormat format) {
            if (format instanceof TextColor) {
                TextColor textColor = (TextColor)format;
                return "<span style='color:" + textColor.asHexString() + "'>";
            }
            if (format == TextDecoration.OBFUSCATED) {
                return "";
            }
            if (format instanceof TextDecoration) {
                TextDecoration decoration = (TextDecoration)format;
                String inner = switch (decoration) {
                    default -> throw new IncompatibleClassChangeError();
                    case TextDecoration.BOLD -> "font-weight:bold";
                    case TextDecoration.ITALIC -> "font-style:italic";
                    case TextDecoration.OBFUSCATED -> throw new IllegalStateException();
                    case TextDecoration.UNDERLINED -> "text-decoration:underline";
                    case TextDecoration.STRIKETHROUGH -> "text-decoration:line-through";
                };
                return "<span style='" + inner + "'>";
            }
            throw new IllegalArgumentException("Cannot handle format: " + format + " (" + format.getClass().getTypeName() + ")");
        }
    }

    public static final class Provider
    implements HtmlComponentSerializer.Provider {
        @Override
        public HtmlComponentSerializer create(ComponentFlattener flattener) {
            return new HtmlComponentSerializerImpl(flattener);
        }
    }
}

