/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.util;

import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import xyz.jpenilla.squaremap.common.Logging;
import xyz.jpenilla.squaremap.common.util.Util;

public final class ExceptionLoggingScheduledThreadPoolExecutor
extends ScheduledThreadPoolExecutor {
    public ExceptionLoggingScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory) {
        super(corePoolSize, threadFactory);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return super.schedule(new ExceptionLoggingRunnable(command), delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return super.scheduleAtFixedRate(new ExceptionLoggingRunnable(command), initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return super.scheduleWithFixedDelay(new ExceptionLoggingRunnable(command), initialDelay, delay, unit);
    }

    private record ExceptionLoggingRunnable(Runnable wrapped) implements Runnable
    {
        @Override
        public void run() {
            try {
                this.wrapped.run();
            }
            catch (Throwable thr) {
                Logging.logger().error("Error executing task '{}'", (Object)this.wrapped, (Object)thr);
                Util.rethrow(thr);
            }
        }
    }
}

