/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.util;

import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ConcurrentFIFOLoadingCache<K, V> {
    private final int maximumCapacity;
    private final int evictUntil;
    private final Function<K, V> loader;
    private final Map<K, V> map;
    private final Queue<K> queue;

    public ConcurrentFIFOLoadingCache(int maximumCapacity, int evictUntil, Function<K, V> loader) {
        if (maximumCapacity <= evictUntil) {
            throw new IllegalArgumentException("maximumCapacity must be larger than evictUntil (%s <= %s)".formatted(maximumCapacity, evictUntil));
        }
        this.maximumCapacity = maximumCapacity;
        this.evictUntil = evictUntil;
        this.loader = loader;
        this.map = new ConcurrentHashMap(maximumCapacity + Runtime.getRuntime().availableProcessors());
        this.queue = new ConcurrentLinkedQueue<K>();
    }

    public V get(K key) {
        @Nullable V cached = this.map.get(key);
        if (cached != null) {
            return cached;
        }
        return this.loadValue(key);
    }

    private V loadValue(K key) {
        V load = this.loader.apply(key);
        @Nullable V prevValue = this.map.putIfAbsent(key, load);
        if (prevValue != null) {
            return prevValue;
        }
        this.queue.offer(key);
        this.maybeEvictEntries();
        return load;
    }

    private void maybeEvictEntries() {
        if (this.map.size() > this.maximumCapacity) {
            K remove;
            while (this.map.size() > this.evictUntil && (remove = this.queue.poll()) != null) {
                this.map.remove(remove);
            }
        }
    }
}

