/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.util;

import java.util.Optional;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.minecraft.server.level.WorldServer;
import org.checkerframework.checker.nullness.qual.Nullable;
import squaremap.libraries.cloud.commandframework.context.CommandContext;
import xyz.jpenilla.squaremap.common.command.Commander;
import xyz.jpenilla.squaremap.common.command.Commands;
import xyz.jpenilla.squaremap.common.command.PlayerCommander;
import xyz.jpenilla.squaremap.common.command.exception.CommandCompleted;
import xyz.jpenilla.squaremap.common.config.Messages;
import xyz.jpenilla.squaremap.common.data.MapWorldInternal;
import xyz.jpenilla.squaremap.common.util.Components;

public final class CommandUtil {
    private CommandUtil() {
    }

    public static MapWorldInternal resolveWorld(CommandContext<Commander> context) {
        Commander sender = context.getSender();
        @Nullable MapWorldInternal world = context.getOrDefault("world", null);
        if (world != null) {
            return world;
        }
        if (sender instanceof PlayerCommander) {
            PlayerCommander player = (PlayerCommander)sender;
            WorldServer level = (WorldServer)player.player().dL();
            Optional<MapWorldInternal> mapWorld = context.get(Commands.WORLD_MANAGER).getWorldIfEnabled(level);
            if (mapWorld.isPresent()) {
                return mapWorld.get();
            }
            throw CommandCompleted.withMessage((ComponentLike)Messages.MAP_NOT_ENABLED_FOR_WORLD.withPlaceholders(new TagResolver[]{Components.worldPlaceholder(level)}).color((TextColor)NamedTextColor.RED));
        }
        throw CommandCompleted.withMessage(Messages.CONSOLE_MUST_SPECIFY_WORLD);
    }
}

