/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import org.checkerframework.checker.nullness.qual.Nullable;
import squaremap.libraries.io.leangen.geantyref.TypeToken;
import squaremap.libraries.org.spongepowered.configurate.CommentedConfigurationNode;
import squaremap.libraries.org.spongepowered.configurate.yaml.NodeStyle;
import squaremap.libraries.org.spongepowered.configurate.yaml.YamlConfigurationLoader;
import xyz.jpenilla.squaremap.common.data.DirectoryProvider;
import xyz.jpenilla.squaremap.common.util.Colors;

public abstract class AbstractFluidColorExporter {
    private final DirectoryProvider directoryProvider;

    protected AbstractFluidColorExporter(DirectoryProvider directoryProvider) {
        this.directoryProvider = directoryProvider;
    }

    public final void export(IRegistryCustom registryAccess) {
        HashMap map = new HashMap();
        registryAccess.d(Registries.e).h().forEach(holder -> {
            Block block = (Block)holder.a();
            @Nullable FluidType fluid = this.fluid(block);
            if (fluid == null || fluid == FluidTypes.c || fluid == FluidTypes.e || fluid == FluidTypes.b || fluid == FluidTypes.d) {
                return;
            }
            @Nullable String color = this.color(fluid);
            if (color != null) {
                map.put(holder.g().a().toString(), color);
            }
        });
        Path file = this.directoryProvider.dataDirectory().resolve("fluids-export.yml");
        YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(file)).nodeStyle(NodeStyle.BLOCK).defaultOptions(options -> options.header("Automatically generated list of fluid colors. You may want to copy these into your server's advanced.yml as block color overrides. See "))).build();
        try {
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            CommentedConfigurationNode node = (CommentedConfigurationNode)loader.createNode();
            node.set(new TypeToken<Map<String, String>>(){}, (Object)map);
            loader.save(node);
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to write fluid color export to " + file, ex);
        }
    }

    protected abstract @Nullable FluidType fluid(Block var1);

    protected abstract @Nullable String color(FluidType var1);

    protected static int color(int blended, int tint) {
        int tintA = tint >> 24 & 0xFF;
        int blendedA = blended >> 24 & 0xFF;
        if (tint == -1) {
            return blended;
        }
        if (Colors.removeAlpha(tint) == -1) {
            int r = blended >> 16 & 0xFF;
            int g = blended >> 8 & 0xFF;
            int b = blended & 0xFF;
            return tintA << 24 | r << 16 | g << 8 | b;
        }
        int a = Math.min(tintA, blendedA);
        float r = (float)(blended >> 16 & 0xFF) / 255.0f;
        float g = (float)(blended >> 8 & 0xFF) / 255.0f;
        float b = (float)(blended & 0xFF) / 255.0f;
        return a << 24 | (int)(r *= (float)(tint >> 16 & 0xFF)) << 16 | (int)(g *= (float)(tint >> 8 & 0xFF)) << 8 | (int)(b *= (float)(tint & 0xFF));
    }
}

