/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.task.render;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import squaremap.libraries.com.google.inject.assistedinject.Assisted;
import squaremap.libraries.com.google.inject.assistedinject.AssistedInject;
import xyz.jpenilla.squaremap.common.Logging;
import xyz.jpenilla.squaremap.common.data.ChunkCoordinate;
import xyz.jpenilla.squaremap.common.data.Image;
import xyz.jpenilla.squaremap.common.data.MapWorldInternal;
import xyz.jpenilla.squaremap.common.data.RegionCoordinate;
import xyz.jpenilla.squaremap.common.task.render.AbstractRender;
import xyz.jpenilla.squaremap.common.util.Util;
import xyz.jpenilla.squaremap.common.util.chunksnapshot.ChunkSnapshotProviderFactory;

public final class BackgroundRender
extends AbstractRender {
    @AssistedInject
    private BackgroundRender(@Assisted MapWorldInternal world, ChunkSnapshotProviderFactory chunkSnapshotProviderFactory) {
        super(world, chunkSnapshotProviderFactory, BackgroundRender.createBackgroundRenderWorkerPool(world));
    }

    @Override
    public int totalChunks() {
        return -1;
    }

    @Override
    public int totalRegions() {
        return -1;
    }

    @Override
    protected void render() {
        long time = System.currentTimeMillis();
        ConcurrentHashMap.KeySetView chunks = ConcurrentHashMap.newKeySet();
        while (this.mapWorld.hasModifiedChunks() && chunks.size() < this.mapWorld.config().BACKGROUND_RENDER_MAX_CHUNKS_PER_INTERVAL) {
            chunks.add(this.mapWorld.nextModifiedChunk());
        }
        if (chunks.isEmpty()) {
            return;
        }
        ArrayList regionFutures = new ArrayList();
        Map<RegionCoordinate, List<ChunkCoordinate>> regionChunksMap = chunks.stream().collect(Collectors.groupingBy(ChunkCoordinate::regionCoordinate));
        regionChunksMap.forEach((region, chunksToRenderInRegion) -> {
            Image image = new Image((RegionCoordinate)region, this.mapWorld.tilesPath(), this.mapWorld.config().ZOOM_MAX);
            CompletableFuture[] chunkFutures = (CompletableFuture[])chunksToRenderInRegion.stream().map(coord -> this.mapSingleChunk(image, coord.x(), coord.z())).toArray(CompletableFuture[]::new);
            regionFutures.add(CompletableFuture.allOf(chunkFutures).thenRun(() -> {
                if (!this.running()) {
                    return;
                }
                chunksToRenderInRegion.forEach(chunks::remove);
                this.mapWorld.saveImage(image);
            }));
        });
        try {
            CompletableFuture.allOf((CompletableFuture[])regionFutures.toArray(CompletableFuture[]::new)).get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (CancellationException | ExecutionException ex) {
            Logging.logger().error("Exception executing background render", (Throwable)ex);
        }
        this.clearCaches();
        chunks.forEach(this.mapWorld::chunkModified);
        Logging.debug(() -> String.format("Finished background render cycle in %.2f seconds", (double)(System.currentTimeMillis() - time) / 1000.0));
    }

    private static ExecutorService createBackgroundRenderWorkerPool(MapWorldInternal world) {
        return Util.newFixedThreadPool(BackgroundRender.getThreads(world.config().BACKGROUND_RENDER_MAX_THREADS, 3), Util.squaremapThreadFactory("bg-render-worker", world.serverLevel()), new ThreadPoolExecutor.DiscardPolicy());
    }
}

