/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.task.render;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockStainedGlass;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import xyz.jpenilla.squaremap.api.Pair;
import xyz.jpenilla.squaremap.common.Logging;
import xyz.jpenilla.squaremap.common.config.Messages;
import xyz.jpenilla.squaremap.common.data.BiomeColors;
import xyz.jpenilla.squaremap.common.data.ChunkCoordinate;
import xyz.jpenilla.squaremap.common.data.Image;
import xyz.jpenilla.squaremap.common.data.MapWorldInternal;
import xyz.jpenilla.squaremap.common.data.RegionCoordinate;
import xyz.jpenilla.squaremap.common.task.render.BackgroundRender;
import xyz.jpenilla.squaremap.common.task.render.RenderProgress;
import xyz.jpenilla.squaremap.common.util.ChunkHashMapKey;
import xyz.jpenilla.squaremap.common.util.Colors;
import xyz.jpenilla.squaremap.common.util.ConcurrentFIFOLoadingCache;
import xyz.jpenilla.squaremap.common.util.Numbers;
import xyz.jpenilla.squaremap.common.util.Util;
import xyz.jpenilla.squaremap.common.util.chunksnapshot.ChunkSnapshot;
import xyz.jpenilla.squaremap.common.util.chunksnapshot.ChunkSnapshotProvider;
import xyz.jpenilla.squaremap.common.util.chunksnapshot.ChunkSnapshotProviderFactory;

public abstract class AbstractRender
implements Runnable {
    private final ExecutorService executorService;
    private final Executor executor;
    private final Supplier<ChunkSnapshotProvider> createChunkSnapshotProvider;
    private final @Nullable Map<Thread, BiomeColors> biomeColors;
    private ChunkSnapshotManager chunks;
    private volatile @MonotonicNonNull Thread thread;
    protected volatile State state = State.RUNNING;
    protected final MapWorldInternal mapWorld;
    protected final WorldServer level;
    protected final AtomicInteger processedChunks = new AtomicInteger(0);
    protected final AtomicInteger processedRegions = new AtomicInteger(0);
    protected volatile @Nullable Pair<Timer, RenderProgress> progress = null;

    protected AbstractRender(MapWorldInternal world, ChunkSnapshotProviderFactory chunkSnapshotProviderFactory) {
        this(world, chunkSnapshotProviderFactory, AbstractRender.createRenderWorkerPool(world));
    }

    protected AbstractRender(MapWorldInternal mapWorld, ChunkSnapshotProviderFactory chunkSnapshotProviderFactory, ExecutorService workerPool) {
        this.mapWorld = mapWorld;
        this.executorService = workerPool;
        this.executor = new RenderWorkerExecutor(workerPool, this::running);
        this.level = mapWorld.serverLevel();
        this.createChunkSnapshotProvider = () -> chunkSnapshotProviderFactory.createChunkSnapshotProvider(this.level);
        this.chunks = this.createChunkSnapshotManager();
        this.biomeColors = this.mapWorld.config().MAP_BIOMES ? new ConcurrentHashMap() : null;
    }

    private int maximumActiveChunkRequests() {
        int factor = Integer.getInteger("squaremap.maximumActiveChunkRequestsFactor", 48);
        int value = ((ThreadPoolExecutor)this.executorService).getCorePoolSize() * factor;
        return Integer.getInteger("squaremap.maximumActiveChunkRequests", value);
    }

    protected abstract void render();

    protected final boolean running() {
        return this.state == State.RUNNING;
    }

    @Override
    public final void run() {
        if (!this.running()) {
            return;
        }
        this.thread = Thread.currentThread();
        try {
            this.render();
        }
        catch (Exception ex) {
            Logging.logger().warn("Encountered exception executing render", (Throwable)ex);
        }
        this.renderStopped();
    }

    private void renderStopped() {
        if (this instanceof BackgroundRender) {
            return;
        }
        State state = this.state;
        this.shutdown();
        this.mapWorld.renderManager().renderStopped(state == State.CANCELLED || state == State.RUNNING);
        String msg = state == State.RUNNING ? Messages.LOG_FINISHED_RENDERING : Messages.LOG_CANCELLED_RENDERING;
        Logging.info(msg, "world", this.mapWorld.identifier().asString());
    }

    private synchronized void shutdown() {
        if (this.progress != null) {
            this.progress.left().cancel();
            this.progress = null;
        }
        if (!this.executorService.isShutdown()) {
            this.executorService.shutdownNow();
        }
    }

    public final void stop() {
        this.stop(State.STOPPED);
    }

    public final void cancel() {
        this.stop(State.CANCELLED);
    }

    private void stop(State state) {
        if (this.state != State.RUNNING) {
            throw new IllegalStateException("Stop already requested");
        }
        this.state = state;
        this.shutdown();
        Thread thread = this.thread;
        if (thread != null) {
            thread.interrupt();
        } else {
            this.renderStopped();
        }
    }

    public abstract int totalChunks();

    public abstract int totalRegions();

    public final int processedChunks() {
        return this.processedChunks.get();
    }

    public final int processedRegions() {
        return this.processedRegions.get();
    }

    protected final void clearCaches() {
        this.chunks = this.createChunkSnapshotManager();
        if (this.biomeColors != null) {
            this.biomeColors.clear();
        }
    }

    private ChunkSnapshotManager createChunkSnapshotManager() {
        return new ChunkSnapshotManager(this.createChunkSnapshotProvider.get(), this.maximumActiveChunkRequests(), this.mapWorld.config().MAP_BIOMES_BLEND > 0, this::running);
    }

    public final void restartProgressLogger() {
        @Nullable Pair<Timer, RenderProgress> progress = this.progress;
        if (progress != null) {
            progress.left().cancel();
            @Nullable RenderProgress old = progress.right();
            this.progress = RenderProgress.printProgress(this, old);
        }
    }

    protected final void mapRegion(RegionCoordinate region) {
        Image image = new Image(region, this.mapWorld.tilesPath(), this.mapWorld.config().ZOOM_MAX);
        int startX = region.getChunkX();
        int startZ = region.getChunkZ();
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        for (int chunkX = startX; chunkX < startX + 32; ++chunkX) {
            futures.add(this.mapChunkColumn(image, chunkX, startZ));
        }
        for (CompletableFuture completableFuture : futures) {
            try {
                completableFuture.get();
            }
            catch (InterruptedException ignore) {
                return;
            }
            catch (CancellationException | ExecutionException ex) {
                Logging.logger().warn("Exception mapping region {}", (Object)region, (Object)ex);
            }
        }
        if (this.running()) {
            this.mapWorld.saveImage(image);
        }
    }

    protected final CompletableFuture<Void> mapSingleChunk(Image image, int chunkX, int chunkZ) {
        CompletableFuture<Object> southChunk;
        CompletableFuture<@Nullable ChunkSnapshot> chunkFuture = this.chunks.snapshot(new ChunkCoordIntPair(chunkX, chunkZ));
        CompletableFuture<@Nullable ChunkSnapshot> northChunk = this.chunks.snapshotDirect(new ChunkCoordIntPair(chunkX, chunkZ - 1));
        int down = chunkZ + 1;
        if (Numbers.chunkToRegion(chunkZ) == Numbers.chunkToRegion(down)) {
            this.chunks.snapshotDirect(new ChunkCoordIntPair(chunkX + 1, down));
            this.chunks.snapshotDirect(new ChunkCoordIntPair(chunkX - 1, down));
            southChunk = this.chunks.snapshotDirect(new ChunkCoordIntPair(chunkX, down));
        } else {
            this.mapWorld.chunkModified(new ChunkCoordinate(chunkX, down));
            southChunk = CompletableFuture.completedFuture(null);
        }
        return ((CompletableFuture)CompletableFuture.allOf(northChunk, chunkFuture, southChunk).thenRunAsync(() -> {
            ChunkSnapshot south;
            ChunkSnapshot chunk;
            if (!this.running()) {
                return;
            }
            int[] lastY = new int[16];
            @Nullable ChunkSnapshot north = (ChunkSnapshot)northChunk.join();
            if (north != null) {
                lastY = this.getLastYFromBottomRow(north);
            }
            if ((chunk = (ChunkSnapshot)chunkFuture.join()) != null) {
                this.scanChunk(image, lastY, chunk);
            }
            if ((south = (ChunkSnapshot)southChunk.join()) != null) {
                this.scanTopRow(image, lastY, south);
            }
            this.processedChunks.incrementAndGet();
        }, this.executor)).exceptionally(thr -> {
            Logging.logger().warn("Exception mapping chunk at [{}, {}] in {}", (Object)chunkX, (Object)chunkZ, (Object)this.mapWorld.identifier().asString(), thr);
            return null;
        });
    }

    protected final CompletableFuture<Void> mapChunkColumn(Image image, int chunkX, int startChunkZ) {
        ArrayList<CompletableFuture<ChunkSnapshot>> futures = new ArrayList<CompletableFuture<ChunkSnapshot>>(33);
        CompletableFuture<@Nullable ChunkSnapshot> aboveChunkFuture = this.chunks.snapshotDirect(new ChunkCoordIntPair(chunkX, startChunkZ - 1));
        futures.add(aboveChunkFuture);
        for (int chunkZ = startChunkZ; chunkZ < startChunkZ + 32; ++chunkZ) {
            if (!this.mapWorld.visibilityLimit().shouldRenderChunk(chunkX, chunkZ)) continue;
            futures.add(this.chunks.snapshot(new ChunkCoordIntPair(chunkX, chunkZ)));
        }
        return ((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new)).thenRunAsync(() -> {
            if (!this.running()) {
                return;
            }
            int[] lastY = new int[16];
            for (CompletableFuture future : futures) {
                @Nullable ChunkSnapshot snapshot = (ChunkSnapshot)future.join();
                if (future == aboveChunkFuture && snapshot != null) {
                    System.arraycopy(this.getLastYFromBottomRow(snapshot), 0, lastY, 0, lastY.length);
                    continue;
                }
                if (snapshot != null) {
                    this.scanChunk(image, lastY, snapshot);
                    this.processedChunks.incrementAndGet();
                    continue;
                }
                this.processedChunks.incrementAndGet();
            }
        }, this.executor)).exceptionally(thr -> {
            Logging.logger().warn("Exception mapping chunk column starting at [{}, {}] in {}", (Object)chunkX, (Object)startChunkZ, (Object)this.mapWorld.identifier().asString(), thr);
            return null;
        });
    }

    private void scanChunk(Image image, int[] lastY, ChunkSnapshot chunk) {
        while (this.mapWorld.renderManager().rendersPaused() && this.running()) {
            AbstractRender.sleep(500);
        }
        int blockX = chunk.pos().d();
        int blockZ = chunk.pos().e();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                if (!this.running()) {
                    return;
                }
                if (!this.mapWorld.visibilityLimit().shouldRenderColumn(blockX + x, blockZ + z)) continue;
                image.setPixel(blockX + x, blockZ + z, this.scanBlock(chunk, x, z, lastY));
            }
        }
    }

    private void scanTopRow(Image image, int[] lastY, ChunkSnapshot chunk) {
        int blockX = chunk.pos().d();
        int blockZ = chunk.pos().e();
        for (int x = 0; x < 16; ++x) {
            if (!this.running()) {
                return;
            }
            if (!this.mapWorld.visibilityLimit().shouldRenderColumn(blockX + x, blockZ)) continue;
            image.setPixel(blockX + x, blockZ, this.scanBlock(chunk, x, 0, lastY));
        }
    }

    private int effectiveMaxHeight(ChunkSnapshot chunk) {
        return this.mapWorld.config().MAP_MAX_HEIGHT == -1 ? chunk.aj() : this.mapWorld.config().MAP_MAX_HEIGHT;
    }

    private int[] getLastYFromBottomRow(ChunkSnapshot chunk) {
        int[] lastY = new int[16];
        BlockPosition.MutableBlockPosition mutablePos = new BlockPosition.MutableBlockPosition();
        for (int x = 0; x < 16; ++x) {
            IBlockData state;
            if (!this.running()) {
                return lastY;
            }
            int topY = chunk.getHeight(HeightMap.Type.b, x, 15) + 1;
            mutablePos.d(chunk.pos().d() + x, Math.min(topY, this.effectiveMaxHeight(chunk)), chunk.pos().e() + 15);
            IBlockData iBlockData = state = this.mapWorld.config().MAP_ITERATE_UP ? this.iterateUp(chunk, mutablePos) : this.iterateDown(chunk, mutablePos);
            if (this.mapWorld.config().MAP_GLASS_CLEAR && AbstractRender.isGlass(state)) {
                this.handleGlass(chunk, mutablePos);
            }
            lastY[x] = mutablePos.v();
        }
        return lastY;
    }

    private int scanBlock(ChunkSnapshot chunk, int imgX, int imgZ, int[] lastY) {
        int blockX = chunk.pos().d() + imgX;
        int blockZ = chunk.pos().e() + imgZ;
        BlockPosition.MutableBlockPosition mutablePos = new BlockPosition.MutableBlockPosition();
        int topY = chunk.getHeight(HeightMap.Type.b, imgX, imgZ) + 1;
        mutablePos.d(blockX, Math.min(topY, this.effectiveMaxHeight(chunk)), blockZ);
        if (topY <= chunk.H_() + 1) {
            return Colors.clearMapColor();
        }
        IBlockData state = this.mapWorld.config().MAP_ITERATE_UP ? this.iterateUp(chunk, mutablePos) : this.iterateDown(chunk, mutablePos);
        if (this.mapWorld.config().MAP_GLASS_CLEAR && AbstractRender.isGlass(state)) {
            int glassColor = this.mapWorld.getMapColor(state);
            float glassAlpha = state.b() == Blocks.aQ ? 0.25f : 0.5f;
            state = this.handleGlass(chunk, mutablePos);
            int color = this.getColor(chunk, imgX, imgZ, lastY, state, mutablePos);
            return Colors.mix(color, glassColor, glassAlpha);
        }
        return this.getColor(chunk, imgX, imgZ, lastY, state, mutablePos);
    }

    private int getColor(ChunkSnapshot chunk, int imgX, int imgZ, int[] lastY, IBlockData state, BlockPosition.MutableBlockPosition mutablePos) {
        int color = this.mapWorld.getMapColor(state);
        if (this.biomeColors != null) {
            color = this.biomeColors.computeIfAbsent(Thread.currentThread(), $ -> new BiomeColors(this.mapWorld, this.chunks)).modifyColorFromBiome(color, chunk, (BlockPosition)mutablePos);
        }
        int odd = imgX + imgZ & 1;
        @Nullable DepthResult fluidDepthResult = AbstractRender.findDepthIfFluid((BlockPosition)mutablePos, state, chunk);
        if (fluidDepthResult != null) {
            int fluidDepth = fluidDepthResult.depth;
            IBlockData blockUnder = fluidDepthResult.state;
            return this.getFluidColor(fluidDepth, color, state, blockUnder, odd);
        }
        int curY = mutablePos.v();
        double diffY = ((double)curY - (double)lastY[imgX]) * 4.0 / 4.0 + ((double)odd - 0.5) * 0.4;
        byte colorOffset = (byte)(diffY > 0.6 ? 2 : (diffY < -0.6 ? 0 : 1));
        lastY[imgX] = curY;
        return Colors.shade(color, colorOffset);
    }

    private IBlockData iterateDown(ChunkSnapshot chunk, BlockPosition.MutableBlockPosition mutablePos) {
        IBlockData state;
        if (chunk.dimensionType().h()) {
            do {
                mutablePos.c(EnumDirection.a);
            } while (!(state = chunk.getBlockState((BlockPosition)mutablePos)).i() && mutablePos.v() > chunk.H_());
        }
        do {
            mutablePos.c(EnumDirection.a);
        } while ((this.mapWorld.getMapColor(state = chunk.getBlockState((BlockPosition)mutablePos)) == Colors.clearMapColor() || this.mapWorld.advanced().invisibleBlocks.contains(state.b())) && mutablePos.v() > chunk.H_());
        return state;
    }

    private IBlockData iterateUp(ChunkSnapshot chunk, BlockPosition.MutableBlockPosition mutablePos) {
        IBlockData state;
        int height = mutablePos.v();
        mutablePos.q(chunk.H_());
        if (chunk.dimensionType().h()) {
            do {
                mutablePos.c(EnumDirection.b);
            } while (!(state = chunk.getBlockState((BlockPosition)mutablePos)).i() && mutablePos.v() < height);
            do {
                mutablePos.c(EnumDirection.b);
            } while (!this.mapWorld.advanced().iterateUpBaseBlocks.contains((state = chunk.getBlockState((BlockPosition)mutablePos)).b()) && mutablePos.v() < height);
        }
        do {
            mutablePos.c(EnumDirection.a);
        } while ((this.mapWorld.getMapColor(state = chunk.getBlockState((BlockPosition)mutablePos)) == Colors.clearMapColor() || this.mapWorld.advanced().invisibleBlocks.contains(state.b())) && mutablePos.v() > chunk.H_());
        return state;
    }

    private static boolean isGlass(IBlockData state) {
        Block block = state.b();
        return block == Blocks.aQ || block instanceof BlockStainedGlass;
    }

    private IBlockData handleGlass(ChunkSnapshot chunk, BlockPosition.MutableBlockPosition mutablePos) {
        IBlockData state = chunk.getBlockState((BlockPosition)mutablePos);
        while (AbstractRender.isGlass(state)) {
            state = this.iterateDown(chunk, mutablePos);
        }
        return state;
    }

    private static @Nullable DepthResult findDepthIfFluid(BlockPosition blockPos, IBlockData state, ChunkSnapshot chunk) {
        if (blockPos.v() > chunk.H_() && !state.u().c()) {
            IBlockData fluidState;
            int fluidDepth = 0;
            int yBelowSurface = blockPos.v() - 1;
            BlockPosition.MutableBlockPosition mutablePos = new BlockPosition.MutableBlockPosition();
            mutablePos.g((BaseBlockPosition)blockPos);
            do {
                mutablePos.q(yBelowSurface--);
                fluidState = chunk.getBlockState((BlockPosition)mutablePos);
            } while (yBelowSurface > chunk.H_() && ++fluidDepth <= 10 && !fluidState.u().c());
            return new DepthResult(fluidDepth, fluidState);
        }
        return null;
    }

    private int getFluidColor(int fluidCountY, int color, IBlockData fluidState, IBlockData underBlock, int odd) {
        FluidType fluid = AbstractRender.fluidTypeForRender(color, fluidState.u());
        boolean shaded = false;
        if (fluid == FluidTypes.c || fluid == FluidTypes.b) {
            if (this.mapWorld.config().MAP_WATER_CHECKERBOARD) {
                color = AbstractRender.applyDepthCheckerboard(fluidCountY, color, odd);
                shaded = true;
            }
            if (this.mapWorld.config().MAP_WATER_CLEAR) {
                if (!this.mapWorld.config().MAP_WATER_CHECKERBOARD) {
                    color = Colors.shade(color, 0.85f - (float)fluidCountY * 0.01f);
                }
                color = Colors.mix(color, this.mapWorld.getMapColor(underBlock), 0.2f / ((float)fluidCountY / 2.0f));
                shaded = true;
            }
        } else if ((fluid == FluidTypes.e || fluid == FluidTypes.d) && this.mapWorld.config().MAP_LAVA_CHECKERBOARD) {
            color = AbstractRender.applyDepthCheckerboard(fluidCountY, color, odd);
            shaded = true;
        }
        return shaded ? color : Colors.removeAlpha(color);
    }

    private static FluidType fluidTypeForRender(int color, Fluid fluidState) {
        FluidType fluid = fluidState.a();
        if (fluid != FluidTypes.c && fluid != FluidTypes.b && fluid != FluidTypes.e && fluid != FluidTypes.d) {
            int a = color >> 24 & 0xFF;
            fluid = a == 255 ? FluidTypes.e : FluidTypes.c;
        }
        return fluid;
    }

    private static int applyDepthCheckerboard(double fluidCountY, int color, double odd) {
        double diffY = fluidCountY * 0.1 + odd * 0.2;
        byte colorOffset = (byte)(diffY < 0.5 ? 2 : (diffY > 0.9 ? 0 : 1));
        return Colors.shade(color, colorOffset);
    }

    private static ExecutorService createRenderWorkerPool(MapWorldInternal world) {
        return Util.newFixedThreadPool(AbstractRender.getThreads(world.config().MAX_RENDER_THREADS), Util.squaremapThreadFactory("render-worker", world.serverLevel()), new ThreadPoolExecutor.DiscardPolicy());
    }

    protected static int getThreads(int threads) {
        return AbstractRender.getThreads(threads, 2);
    }

    protected static int getThreads(int threads, int factor) {
        if (threads == -1) {
            threads = Runtime.getRuntime().availableProcessors() / factor;
        }
        return Math.max(1, threads);
    }

    protected static void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected static enum State {
        RUNNING,
        STOPPED,
        CANCELLED;

    }

    private record RenderWorkerExecutor(Executor wrapped, BooleanSupplier running) implements Executor
    {
        @Override
        public void execute(Runnable task) {
            this.wrapped.execute(new WorkerTask(task, this.running));
        }

        private record WorkerTask(Runnable wrapped, BooleanSupplier running) implements Runnable
        {
            @Override
            public void run() {
                if (this.running.getAsBoolean()) {
                    this.wrapped.run();
                }
            }
        }
    }

    public static final class ChunkSnapshotManager {
        private static final int MAXIMUM_CAPACITY = 2048;
        private final ChunkSnapshotProvider chunkSnapshotProvider;
        private final int maximumActiveRequests;
        private final ConcurrentFIFOLoadingCache<ChunkHashMapKey, CompletableFuture<@Nullable ChunkSnapshot>> cache;
        public final AtomicLong active = new AtomicLong();
        public final AtomicLong done = new AtomicLong();
        private final boolean biomeBlend;
        private final BooleanSupplier running;

        public ChunkSnapshotManager(ChunkSnapshotProvider chunkSnapshotProvider, int maximumActiveRequests, boolean biomeBlend, BooleanSupplier running) {
            this.chunkSnapshotProvider = chunkSnapshotProvider;
            this.maximumActiveRequests = maximumActiveRequests;
            this.cache = new ConcurrentFIFOLoadingCache<ChunkHashMapKey, CompletableFuture>(2048, 1638, this::load);
            this.biomeBlend = biomeBlend;
            this.running = running;
        }

        private CompletableFuture<ChunkSnapshot> load(ChunkHashMapKey key) {
            if (!this.maybeWait()) {
                return CompletableFuture.completedFuture(null);
            }
            this.active.incrementAndGet();
            CompletableFuture<@Nullable ChunkSnapshot> future = this.chunkSnapshotProvider.asyncSnapshot(ChunkCoordIntPair.a((long)key.key), ChunkCoordIntPair.b((long)key.key));
            future.whenComplete(($, $$) -> this.done.incrementAndGet());
            return future;
        }

        private boolean maybeWait() {
            int failures = 1;
            while (this.active.get() - this.done.get() >= (long)this.maximumActiveRequests) {
                if (!this.running.getAsBoolean()) {
                    return false;
                }
                boolean interrupted = Thread.interrupted();
                Thread.yield();
                LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(Math.min(10, failures)));
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
                ++failures;
            }
            return true;
        }

        public CompletableFuture<@Nullable ChunkSnapshot> snapshot(ChunkCoordIntPair chunkPos) {
            CompletableFuture<@Nullable ChunkSnapshot> future = this.snapshotDirect(chunkPos);
            if (!this.biomeBlend) {
                return future;
            }
            int x = chunkPos.e;
            int z = chunkPos.f;
            List<CompletableFuture<@Nullable ChunkSnapshot>> neighborFutures = List.of(this.snapshotDirect(new ChunkCoordIntPair(x - 1, z - 1)), this.snapshotDirect(new ChunkCoordIntPair(x, z - 1)), this.snapshotDirect(new ChunkCoordIntPair(x + 1, z + 1)), this.snapshotDirect(new ChunkCoordIntPair(x - 1, z)), this.snapshotDirect(new ChunkCoordIntPair(x + 1, z)), this.snapshotDirect(new ChunkCoordIntPair(x - 1, z + 1)), this.snapshotDirect(new ChunkCoordIntPair(x, z + 1)), this.snapshotDirect(new ChunkCoordIntPair(x + 1, z - 1)));
            return CompletableFuture.allOf((CompletableFuture[])neighborFutures.toArray(CompletableFuture[]::new)).thenCompose($ -> future);
        }

        public CompletableFuture<@Nullable ChunkSnapshot> snapshotDirect(ChunkCoordIntPair chunkPos) {
            return this.cache.get(new ChunkHashMapKey(chunkPos));
        }
    }

    private record DepthResult(int depth, IBlockData state) {
    }
}

