/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPosition;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.World;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import squaremap.libraries.com.google.inject.Inject;
import xyz.jpenilla.squaremap.api.MapWorld;
import xyz.jpenilla.squaremap.api.WorldIdentifier;
import xyz.jpenilla.squaremap.common.WorldManager;
import xyz.jpenilla.squaremap.common.config.Config;
import xyz.jpenilla.squaremap.common.config.Messages;
import xyz.jpenilla.squaremap.common.config.WorldConfig;
import xyz.jpenilla.squaremap.common.data.DirectoryProvider;
import xyz.jpenilla.squaremap.common.data.MapWorldInternal;
import xyz.jpenilla.squaremap.common.util.FileUtil;
import xyz.jpenilla.squaremap.common.util.Util;

public final class UpdateWorldData
implements Runnable {
    private final WorldManager worldManager;
    private final DirectoryProvider directoryProvider;
    private @MonotonicNonNull Map<WorldIdentifier, ChangingData> lastUpdate = null;

    @Inject
    private UpdateWorldData(WorldManager worldManager, DirectoryProvider directoryProvider) {
        this.worldManager = worldManager;
        this.directoryProvider = directoryProvider;
    }

    @Override
    public void run() {
        if (this.lastUpdate != null) {
            Map<WorldIdentifier, ChangingData> current = this.worldManager.worlds().stream().collect(Collectors.toMap(MapWorld::identifier, ChangingData::snapshot));
            if (this.lastUpdate.equals(current)) {
                return;
            }
            this.lastUpdate.clear();
        } else {
            this.lastUpdate = new HashMap<WorldIdentifier, ChangingData>();
        }
        ArrayList worlds = new ArrayList();
        this.worldManager.worlds().forEach(mapWorld -> {
            this.lastUpdate.put(mapWorld.identifier(), ChangingData.snapshot(mapWorld));
            WorldServer level = mapWorld.serverLevel();
            WorldConfig worldConfig = mapWorld.config();
            this.writeWorldSettings((MapWorldInternal)mapWorld, level, worldConfig);
            HashMap<String, Object> worldsList = new HashMap<String, Object>();
            worldsList.put("name", Util.levelWebName(level));
            worldsList.put("display_name", worldConfig.MAP_DISPLAY_NAME.replace("{world}", Util.levelConfigName(level)));
            worldsList.put("icon", worldConfig.MAP_ICON);
            worldsList.put("type", UpdateWorldData.environment(level));
            worldsList.put("order", worldConfig.MAP_ORDER);
            worlds.add(worldsList);
        });
        HashMap<String, Object> ui = new HashMap<String, Object>();
        ui.put("title", Messages.UI_TITLE);
        HashMap<String, Object> coordinates = new HashMap<String, Object>();
        coordinates.put("enabled", Config.UI_COORDINATES_ENABLED);
        coordinates.put("html", Messages.UI_COORDINATES_HTML);
        ui.put("coordinates", coordinates);
        HashMap<String, Boolean> link = new HashMap<String, Boolean>();
        link.put("enabled", Config.UI_LINK_ENABLED);
        ui.put("link", link);
        HashMap<String, String> sidebar = new HashMap<String, String>();
        sidebar.put("pinned", Config.UI_SIDEBAR_PINNED);
        sidebar.put("player_list_label", Messages.UI_SIDEBAR_PLAYER_LIST_LABEL);
        sidebar.put("world_list_label", Messages.UI_SIDEBAR_WORLD_LIST_LABEL);
        ui.put("sidebar", sidebar);
        HashMap<String, Cloneable> map = new HashMap<String, Cloneable>();
        map.put("worlds", worlds);
        map.put("ui", ui);
        FileUtil.atomicWriteJsonAsync(this.directoryProvider.tilesDirectory().resolve("settings.json"), map);
    }

    private void writeWorldSettings(MapWorldInternal mapWorld, WorldServer level, WorldConfig worldConfig) {
        HashMap<String, Integer> spawn = new HashMap<String, Integer>();
        BlockPosition loc = level.R();
        spawn.put("x", loc.u());
        spawn.put("z", loc.w());
        HashMap<String, Object> playerTracker = new HashMap<String, Object>();
        playerTracker.put("enabled", worldConfig.PLAYER_TRACKER_ENABLED);
        playerTracker.put("update_interval", worldConfig.PLAYER_TRACKER_UPDATE_INTERVAL);
        playerTracker.put("label", Messages.UI_PLAYER_TRACKER_LABEL);
        playerTracker.put("show_controls", worldConfig.PLAYER_TRACKER_SHOW_CONTROLS);
        playerTracker.put("default_hidden", worldConfig.PLAYER_TRACKER_DEFAULT_HIDDEN);
        playerTracker.put("priority", worldConfig.PLAYER_TRACKER_PRIORITY);
        playerTracker.put("z_index", worldConfig.PLAYER_TRACKER_Z_INDEX);
        HashMap<String, Object> nameplates = new HashMap<String, Object>();
        nameplates.put("enabled", worldConfig.PLAYER_TRACKER_NAMEPLATE_ENABLED);
        nameplates.put("show_heads", worldConfig.PLAYER_TRACKER_NAMEPLATE_SHOW_HEAD);
        nameplates.put("heads_url", worldConfig.PLAYER_TRACKER_NAMEPLATE_HEADS_URL);
        nameplates.put("show_armor", worldConfig.PLAYER_TRACKER_NAMEPLATE_SHOW_ARMOR);
        nameplates.put("show_health", worldConfig.PLAYER_TRACKER_NAMEPLATE_SHOW_HEALTH);
        playerTracker.put("nameplates", nameplates);
        HashMap<String, Integer> zoom = new HashMap<String, Integer>();
        zoom.put("max", worldConfig.ZOOM_MAX);
        zoom.put("def", worldConfig.ZOOM_DEFAULT);
        zoom.put("extra", worldConfig.ZOOM_EXTRA);
        HashMap<String, Serializable> settings = new HashMap<String, Serializable>();
        settings.put("spawn", spawn);
        settings.put("player_tracker", playerTracker);
        settings.put("zoom", zoom);
        settings.put("marker_update_interval", Integer.valueOf(worldConfig.MARKER_API_UPDATE_INTERVAL_SECONDS));
        settings.put("tiles_update_interval", Integer.valueOf(worldConfig.BACKGROUND_RENDER_INTERVAL_SECONDS));
        FileUtil.atomicWriteJsonAsync(mapWorld.tilesPath().resolve("settings.json"), settings);
    }

    private static String environment(WorldServer level) {
        ResourceKey dimensionKey = level.ac();
        if (dimensionKey == World.i) {
            return "nether";
        }
        if (dimensionKey == World.j) {
            return "the_end";
        }
        if (dimensionKey == World.h) {
            return "normal";
        }
        return "custom";
    }

    private record ChangingData(BlockPosition spawn, long lastReset) {
        static ChangingData snapshot(MapWorldInternal world) {
            return new ChangingData(world.serverLevel().R(), world.lastReset());
        }
    }
}

