/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import net.kyori.adventure.text.flattener.ComponentFlattener;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.phys.Vec3D;
import org.checkerframework.checker.nullness.qual.Nullable;
import squaremap.libraries.com.google.inject.Inject;
import squaremap.libraries.com.google.inject.Provider;
import xyz.jpenilla.squaremap.api.HtmlComponentSerializer;
import xyz.jpenilla.squaremap.common.AbstractPlayerManager;
import xyz.jpenilla.squaremap.common.ServerAccess;
import xyz.jpenilla.squaremap.common.config.ConfigManager;
import xyz.jpenilla.squaremap.common.config.WorldConfig;
import xyz.jpenilla.squaremap.common.data.DirectoryProvider;
import xyz.jpenilla.squaremap.common.util.FileUtil;
import xyz.jpenilla.squaremap.common.util.Util;

public class UpdatePlayers
implements Runnable {
    private final Provider<ComponentFlattener> flattener;
    private final AbstractPlayerManager playerManager;
    private final DirectoryProvider directoryProvider;
    private final ServerAccess serverAccess;
    private final ConfigManager configManager;
    private boolean prevEmpty = false;
    private int prevMaxPlayers = Integer.MIN_VALUE;

    @Inject
    private UpdatePlayers(Provider<ComponentFlattener> flattener, AbstractPlayerManager playerManager, DirectoryProvider directoryProvider, ServerAccess serverAccess, ConfigManager configManager) {
        this.flattener = flattener;
        this.playerManager = playerManager;
        this.directoryProvider = directoryProvider;
        this.serverAccess = serverAccess;
        this.configManager = configManager;
    }

    @Override
    public void run() {
        ArrayList players = new ArrayList();
        HtmlComponentSerializer htmlComponentSerializer = HtmlComponentSerializer.withFlattener(this.flattener.get());
        this.serverAccess.levels().forEach(world -> {
            WorldConfig worldConfig = this.configManager.worldConfig((WorldServer)world);
            world.v().forEach(player -> {
                if (worldConfig.PLAYER_TRACKER_HIDE_SPECTATORS && player.e.b() == EnumGamemode.d) {
                    return;
                }
                if (worldConfig.PLAYER_TRACKER_HIDE_INVISIBLE && player.cd()) {
                    return;
                }
                if (this.playerManager.hidden((EntityPlayer)player) || this.playerManager.otherwiseHidden((EntityPlayer)player)) {
                    return;
                }
                HashMap<String, Object> playerEntry = new HashMap<String, Object>();
                Vec3D playerLoc = player.dj();
                playerEntry.put("name", player.fQ().getName());
                if (worldConfig.PLAYER_TRACKER_USE_DISPLAY_NAME) {
                    playerEntry.put("display_name", htmlComponentSerializer.serialize(this.playerManager.displayName((EntityPlayer)player)));
                }
                playerEntry.put("uuid", player.cv().toString().replace("-", ""));
                playerEntry.put("world", Util.levelWebName(world));
                if (worldConfig.PLAYER_TRACKER_ENABLED) {
                    playerEntry.put("x", MathHelper.a((double)playerLoc.a()));
                    playerEntry.put("z", MathHelper.a((double)playerLoc.c()));
                    playerEntry.put("yaw", Float.valueOf(player.co()));
                    if (worldConfig.PLAYER_TRACKER_NAMEPLATE_SHOW_ARMOR) {
                        playerEntry.put("armor", UpdatePlayers.armorPoints(player));
                    }
                    if (worldConfig.PLAYER_TRACKER_NAMEPLATE_SHOW_HEALTH) {
                        playerEntry.put("health", (int)player.eu());
                    }
                }
                players.add(playerEntry);
            });
        });
        int maxPlayers = this.serverAccess.maxPlayers();
        if (players.isEmpty() && this.prevEmpty && maxPlayers == this.prevMaxPlayers) {
            return;
        }
        this.prevEmpty = players.isEmpty();
        this.prevMaxPlayers = maxPlayers;
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("players", players);
        map.put("max", Integer.valueOf(maxPlayers));
        FileUtil.atomicWriteJsonAsync(this.directoryProvider.tilesDirectory().resolve("players.json"), map);
    }

    private static int armorPoints(EntityPlayer player) {
        @Nullable AttributeModifiable attribute = player.a(GenericAttributes.i);
        return attribute == null ? 0 : (int)attribute.f();
    }
}

