/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.task;

import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.awt.Color;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import xyz.jpenilla.squaremap.api.Key;
import xyz.jpenilla.squaremap.api.LayerProvider;
import xyz.jpenilla.squaremap.api.Point;
import xyz.jpenilla.squaremap.api.Registry;
import xyz.jpenilla.squaremap.api.marker.Circle;
import xyz.jpenilla.squaremap.api.marker.Ellipse;
import xyz.jpenilla.squaremap.api.marker.Icon;
import xyz.jpenilla.squaremap.api.marker.Marker;
import xyz.jpenilla.squaremap.api.marker.MarkerOptions;
import xyz.jpenilla.squaremap.api.marker.MultiPolygon;
import xyz.jpenilla.squaremap.api.marker.Polygon;
import xyz.jpenilla.squaremap.api.marker.Polyline;
import xyz.jpenilla.squaremap.api.marker.Rectangle;
import xyz.jpenilla.squaremap.common.data.MapWorldInternal;
import xyz.jpenilla.squaremap.common.util.FileUtil;

public final class UpdateMarkers
implements Runnable {
    private final MapWorldInternal mapWorld;
    private final Object2LongMap<Key> lastUpdatedTime = new Object2LongOpenHashMap();
    private final Map<Key, Map<String, Object>> layerCache = new HashMap<Key, Map<String, Object>>();
    private final Map<Key, Map<String, Object>> serializedLayerCache = new HashMap<Key, Map<String, Object>>();
    private long lastResetTime = Long.MIN_VALUE;
    private static final Map<Class<? extends Marker>, MarkerSerializer<?>> serializers = new HashMap();

    public UpdateMarkers(@NonNull MapWorldInternal mapWorld) {
        this.mapWorld = mapWorld;
    }

    @Override
    public void run() {
        Registry<LayerProvider> layerRegistry = this.mapWorld.layerRegistry();
        ArrayList layers = new ArrayList();
        HashSet layerKeys = new HashSet();
        boolean[] changed = new boolean[]{false};
        layerRegistry.entries().forEach(registeredLayer -> {
            LayerProvider provider = (LayerProvider)registeredLayer.right();
            Key key = (Key)registeredLayer.left();
            layerKeys.add(key);
            List<Marker> markers = List.copyOf(provider.getMarkers());
            Map<String, Object> current = this.createMap(key, provider);
            current.put("markers", markers.hashCode());
            Map<String, Object> previous = this.layerCache.get(key);
            if (previous == null || !previous.equals(current)) {
                changed[0] = true;
                this.layerCache.put(key, current);
                Map<String, Object> serializedLayer = this.serializeLayer(key, provider, markers);
                this.serializedLayerCache.put(key, serializedLayer);
                long time = System.currentTimeMillis();
                this.lastUpdatedTime.put((Object)key, time);
                HashMap<String, Object> timeStampedLayer = new HashMap<String, Object>(serializedLayer);
                timeStampedLayer.put("timestamp", time);
                layers.add(timeStampedLayer);
            } else {
                Map<String, Object> serializedLayer = this.serializedLayerCache.get(key);
                long lastUpdate = this.lastUpdatedTime.getLong((Object)key);
                HashMap<String, Object> timeStampedLayer = new HashMap<String, Object>(serializedLayer);
                timeStampedLayer.put("timestamp", lastUpdate);
                layers.add(timeStampedLayer);
            }
        });
        changed[0] = changed[0] | UpdateMarkers.clearUnused(layerKeys, this.layerCache);
        changed[0] = changed[0] | UpdateMarkers.clearUnused(layerKeys, this.serializedLayerCache);
        changed[0] = changed[0] | UpdateMarkers.clearUnused(layerKeys, this.lastUpdatedTime);
        if (changed[0] || this.mapWorld.lastReset() != this.lastResetTime) {
            this.lastResetTime = this.mapWorld.lastReset();
            Path file = this.mapWorld.tilesPath().resolve("markers.json");
            FileUtil.atomicWriteJsonAsync(file, layers);
        }
    }

    private static <K> boolean clearUnused(Set<K> keepKeys, Map<K, ?> map) {
        boolean madeChange = false;
        for (K key : Set.copyOf(map.keySet())) {
            if (keepKeys.contains(key)) continue;
            madeChange = true;
            if (map instanceof Object2LongMap) {
                Object2LongMap longMap = (Object2LongMap)map;
                longMap.removeLong(key);
                continue;
            }
            map.remove(key);
        }
        return madeChange;
    }

    private @NonNull Map<String, Object> serializeLayer(@NonNull Key key, @NonNull LayerProvider provider, @NonNull List<Marker> markers) {
        Map<String, Object> map = this.createMap(key, provider);
        map.put("markers", this.serializeMarkers(markers));
        return map;
    }

    private Map<String, Object> createMap(Key key, LayerProvider provider) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", key.getKey());
        map.put("name", provider.getLabel());
        map.put("control", provider.showControls());
        map.put("hide", provider.defaultHidden());
        map.put("order", provider.layerPriority());
        map.put("z_index", provider.zIndex());
        return map;
    }

    private @NonNull List<Map<String, Object>> serializeMarkers(@NonNull Collection<Marker> markers) {
        ArrayList<Map<String, Object>> processed = new ArrayList<Map<String, Object>>();
        for (Marker marker : markers) {
            HashMap<String, Object> markerMap = new HashMap<String, Object>();
            UpdateMarkers.populateOptions(markerMap, marker.markerOptions());
            UpdateMarkers.serialize(marker, markerMap);
            processed.add(markerMap);
        }
        return processed;
    }

    private static void populateOptions(@NonNull Map<String, Object> marker, @NonNull MarkerOptions options) {
        String hoverTooltip;
        String clickTooltip;
        Color fillColor;
        MarkerOptions defaults = MarkerOptions.defaultOptions();
        if (options.stroke() != defaults.stroke()) {
            marker.put("stroke", options.stroke());
        }
        if (!options.strokeColor().equals(defaults.strokeColor())) {
            marker.put("color", UpdateMarkers.toHexString(options.strokeColor()));
        }
        if (options.strokeWeight() != defaults.strokeWeight()) {
            marker.put("weight", options.strokeWeight());
        }
        if (options.strokeOpacity() != defaults.strokeOpacity()) {
            marker.put("opacity", options.strokeOpacity());
        }
        if (options.fill() != defaults.fill()) {
            marker.put("fill", options.fill());
        }
        if ((fillColor = options.fillColor()) != null) {
            marker.put("fillColor", UpdateMarkers.toHexString(fillColor));
        }
        if (options.fillOpacity() != defaults.fillOpacity()) {
            marker.put("fillOpacity", options.fillOpacity());
        }
        if (options.fillRule() != defaults.fillRule()) {
            marker.put("fillRule", options.fillRule().toString().toLowerCase(Locale.ENGLISH));
        }
        if ((clickTooltip = options.clickTooltip()) != null) {
            marker.put("popup", clickTooltip);
        }
        if ((hoverTooltip = options.hoverTooltip()) != null) {
            marker.put("tooltip", hoverTooltip);
        }
    }

    private static @NonNull String toHexString(@NonNull Color color) {
        return "#" + Integer.toHexString(color.getRGB()).substring(2);
    }

    private static <T extends Marker> void serialize(@NonNull T marker, @NonNull Map<String, Object> destination) {
        Class<?> markerClass = marker.getClass();
        MarkerSerializer<?> markerSerializer = serializers.get(markerClass);
        if (markerSerializer == null) {
            throw new IllegalStateException("unknown marker type! no serializer present for " + markerClass.getName());
        }
        markerSerializer.serialize(destination, marker);
    }

    private static <T extends Marker> void register(@NonNull Class<T> markerClass, @NonNull MarkerSerializer<T> serializer) {
        serializers.put(markerClass, serializer);
    }

    private static @NonNull List<List<Map<String, Integer>>> serializePoints(@NonNull Stream<List<Point>> stream) {
        return stream.map(points -> points.stream().map(UpdateMarkers::toMap).toList()).toList();
    }

    private static @NonNull Map<String, Integer> toMap(@NonNull Point point) {
        return Map.of("x", (int)point.x(), "z", (int)point.z());
    }

    static {
        UpdateMarkers.register(Polyline.class, (destination, line) -> {
            destination.put("type", "polyline");
            List<Object> points = line.points().size() == 1 ? line.points().get(0).stream().map(UpdateMarkers::toMap).toList() : UpdateMarkers.serializePoints(line.points().stream());
            destination.put("points", points);
        });
        UpdateMarkers.register(Rectangle.class, (destination, rectangle) -> {
            destination.put("type", "rectangle");
            destination.put("points", List.of(UpdateMarkers.toMap(rectangle.point1()), UpdateMarkers.toMap(rectangle.point2())));
        });
        UpdateMarkers.register(Circle.class, (destination, circle) -> {
            destination.put("type", "circle");
            destination.put("center", UpdateMarkers.toMap(circle.center()));
            destination.put("radius", circle.radius());
        });
        UpdateMarkers.register(Ellipse.class, (destination, ellipse) -> {
            destination.put("type", "ellipse");
            destination.put("center", UpdateMarkers.toMap(ellipse.center()));
            destination.put("radiusX", ellipse.radiusX());
            destination.put("radiusZ", ellipse.radiusZ());
        });
        UpdateMarkers.register(Polygon.class, (destination, polygon) -> {
            destination.put("type", "polygon");
            ArrayList<List<Point>> list = new ArrayList<List<Point>>(Collections.singleton(polygon.mainPolygon()));
            list.addAll(polygon.negativeSpace());
            destination.put("points", UpdateMarkers.serializePoints(list.stream()));
        });
        UpdateMarkers.register(MultiPolygon.class, (destination, multiPolygon) -> {
            destination.put("type", "polygon");
            destination.put("points", multiPolygon.subPolygons().stream().map(subPoly -> {
                ArrayList<List<Point>> list = new ArrayList<List<Point>>(Collections.singleton(subPoly.mainPolygon()));
                list.addAll(subPoly.negativeSpace());
                return UpdateMarkers.serializePoints(list.stream());
            }).toList());
        });
        UpdateMarkers.register(Icon.class, (destination, icon) -> {
            destination.put("type", "icon");
            destination.put("point", UpdateMarkers.toMap(icon.point()));
            destination.put("size", UpdateMarkers.toMap(Point.of(icon.sizeX(), icon.sizeZ())));
            destination.put("anchor", UpdateMarkers.toMap(icon.anchor()));
            destination.put("tooltip_anchor", UpdateMarkers.toMap(icon.tooltipAnchor()));
            destination.put("icon", icon.image().getKey());
        });
    }

    @FunctionalInterface
    private static interface MarkerSerializer<T extends Marker> {
        public void serialize(@NonNull Map<String, Object> var1, @NonNull T var2);
    }
}

