/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.network;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import org.checkerframework.checker.nullness.qual.Nullable;
import squaremap.libraries.com.google.inject.Inject;
import xyz.jpenilla.squaremap.common.ServerAccess;
import xyz.jpenilla.squaremap.common.WorldManager;
import xyz.jpenilla.squaremap.common.config.Config;
import xyz.jpenilla.squaremap.common.data.MapWorldInternal;
import xyz.jpenilla.squaremap.common.util.Util;

public final class NetworkingHandler {
    public static final MinecraftKey CHANNEL = new MinecraftKey("squaremap:client");
    private final WorldManager worldManager;
    private final ServerAccess serverAccess;
    private final Set<UUID> clientUsers;

    @Inject
    public NetworkingHandler(WorldManager worldManager, ServerAccess serverAccess) {
        this.worldManager = worldManager;
        this.serverAccess = serverAccess;
        this.clientUsers = ConcurrentHashMap.newKeySet();
    }

    public void onDisconnect(UUID playerUuid) {
        this.clientUsers.remove(playerUuid);
    }

    public void handleIncoming(EntityPlayer player, byte[] data, Predicate<WorldMap> isVanillaMap) {
        ByteArrayDataInput in = NetworkingHandler.in(data);
        int action = in.readInt();
        switch (action) {
            case 0: {
                this.clientUsers.add(player.cv());
                this.sendServerData(player);
                break;
            }
            case 1: {
                int id = in.readInt();
                this.sendMapData(player, id, isVanillaMap);
            }
        }
    }

    private void sendServerData(EntityPlayer player) {
        ByteArrayDataOutput out = NetworkingHandler.out();
        out.writeInt(0);
        out.writeInt(3);
        out.writeInt(200);
        out.writeUTF(Config.WEB_ADDRESS);
        Collection<MapWorldInternal> mapWorlds = this.worldManager.worlds();
        out.writeInt(mapWorlds.size());
        for (MapWorldInternal mapWorld : mapWorlds) {
            out.writeUTF(mapWorld.identifier().asString());
            out.writeUTF(Util.levelWebName(mapWorld.serverLevel()));
            out.writeInt(mapWorld.config().ZOOM_MAX);
            out.writeInt(mapWorld.config().ZOOM_DEFAULT);
            out.writeInt(mapWorld.config().ZOOM_EXTRA);
        }
        out.writeUTF(player.dL().ac().a().toString());
        NetworkingHandler.send(player, out);
    }

    private void sendMapData(EntityPlayer player, int id, Predicate<WorldMap> isVanillaMap) {
        ByteArrayDataOutput data = this.mapData(player, id, isVanillaMap);
        NetworkingHandler.send(player, data);
    }

    private ByteArrayDataOutput mapData(EntityPlayer player, int id, Predicate<WorldMap> isVanillaMap) {
        ByteArrayDataOutput out = NetworkingHandler.out();
        out.writeInt(1);
        out.writeInt(3);
        @Nullable WorldMap mapData = player.dL().a(ItemWorldMap.a((int)id));
        if (mapData == null) {
            out.writeInt(-1);
            out.writeInt(id);
            return out;
        }
        @Nullable WorldServer world = this.serverAccess.level(Util.worldIdentifier(mapData.e.a()));
        if (world == null) {
            out.writeInt(-2);
            out.writeInt(id);
            return out;
        }
        if (!isVanillaMap.test(mapData)) {
            out.writeInt(-3);
            out.writeInt(id);
            return out;
        }
        out.writeInt(200);
        out.writeInt(id);
        out.writeByte((int)mapData.f);
        out.writeInt(mapData.c);
        out.writeInt(mapData.d);
        out.writeUTF(world.ac().a().toString());
        return out;
    }

    public void worldChanged(EntityPlayer player) {
        if (!this.clientUsers.contains(player.cv())) {
            return;
        }
        ByteArrayDataOutput out = NetworkingHandler.out();
        out.writeInt(2);
        out.writeInt(3);
        out.writeInt(200);
        out.writeUTF(player.dL().ac().a().toString());
        NetworkingHandler.send(player, out);
    }

    private static void send(EntityPlayer player, ByteArrayDataOutput out) {
        ClientboundCustomPayloadPacket packet = new ClientboundCustomPayloadPacket((CustomPacketPayload)new SquaremapClientPayload(out));
        player.c.b((Packet)packet);
    }

    private static ByteArrayDataOutput out() {
        return ByteStreams.newDataOutput();
    }

    private static ByteArrayDataInput in(byte[] bytes) {
        return ByteStreams.newDataInput((byte[])bytes);
    }

    private record SquaremapClientPayload(ByteArrayDataOutput out) implements CustomPacketPayload
    {
        public void a(PacketDataSerializer friendlyByteBuf) {
            friendlyByteBuf.c(this.out.toByteArray());
        }

        public MinecraftKey a() {
            return CHANNEL;
        }
    }
}

