/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.inject;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import squaremap.libraries.com.google.inject.Module;
import squaremap.libraries.com.google.inject.assistedinject.FactoryModuleBuilder;
import xyz.jpenilla.squaremap.common.SquaremapPlatform;
import xyz.jpenilla.squaremap.common.WorldManagerImpl;
import xyz.jpenilla.squaremap.common.data.MapWorldInternal;
import xyz.jpenilla.squaremap.common.inject.module.ApiModule;
import xyz.jpenilla.squaremap.common.inject.module.PlatformModule;
import xyz.jpenilla.squaremap.common.inject.module.VanillaChunkSnapshotProviderFactoryModule;
import xyz.jpenilla.squaremap.common.inject.module.VanillaRegionFileDirectoryResolverModule;
import xyz.jpenilla.squaremap.common.task.render.RenderFactory;
import xyz.jpenilla.squaremap.common.util.EntityScheduler;
import xyz.jpenilla.squaremap.common.util.SquaremapJarAccess;

public final class SquaremapModulesBuilder {
    private final @Nullable SquaremapPlatform platform;
    private final @Nullable Class<? extends SquaremapPlatform> platformClass;
    private final List<Module> extraModules = new ArrayList<Module>();
    private boolean vanillaRegionFileDirectoryResolver;
    private boolean vanillaChunkSnapshotProviderFactory;
    private @Nullable Class<? extends MapWorldInternal> mapWorldClass;
    private Class<? extends SquaremapJarAccess> squaremapJarAccess = SquaremapJarAccess.JarFromCodeSource.class;
    private Class<? extends EntityScheduler> entitySchedulerClass = EntityScheduler.NoneEntityScheduler.class;
    private Class<? extends WorldManagerImpl> worldManagerClass = WorldManagerImpl.class;

    private SquaremapModulesBuilder(SquaremapPlatform platform) {
        this.platform = platform;
        this.platformClass = null;
    }

    private SquaremapModulesBuilder(Class<? extends SquaremapPlatform> platformClass) {
        this.platform = null;
        this.platformClass = platformClass;
    }

    public SquaremapModulesBuilder worldManager(Class<? extends WorldManagerImpl> worldManagerClass) {
        this.worldManagerClass = worldManagerClass;
        return this;
    }

    public SquaremapModulesBuilder mapWorld(Class<? extends MapWorldInternal> mapWorldClass) {
        this.mapWorldClass = mapWorldClass;
        return this;
    }

    public SquaremapModulesBuilder vanillaChunkSnapshotProviderFactory() {
        this.vanillaChunkSnapshotProviderFactory = true;
        return this;
    }

    public SquaremapModulesBuilder vanillaRegionFileDirectoryResolver() {
        this.vanillaRegionFileDirectoryResolver = true;
        return this;
    }

    public SquaremapModulesBuilder entityScheduler(Class<? extends EntityScheduler> entitySchedulerClass) {
        this.entitySchedulerClass = entitySchedulerClass;
        return this;
    }

    public SquaremapModulesBuilder withModules(Module ... modules) {
        this.extraModules.addAll(Arrays.asList(modules));
        return this;
    }

    public SquaremapModulesBuilder withModule(Module module) {
        this.extraModules.add(module);
        return this;
    }

    public SquaremapModulesBuilder squaremapJarAccess(Class<? extends SquaremapJarAccess> squaremapJarAccess) {
        this.squaremapJarAccess = squaremapJarAccess;
        return this;
    }

    public List<Module> build() {
        Objects.requireNonNull(this.mapWorldClass, "mapWorldClass");
        List<Module> baseModules = List.of(new ApiModule(), new PlatformModule(this.platform, this.platformClass, this.squaremapJarAccess, this.entitySchedulerClass, this.worldManagerClass), new FactoryModuleBuilder().build(RenderFactory.class), new FactoryModuleBuilder().implement(MapWorldInternal.class, this.mapWorldClass).build(MapWorldInternal.Factory.class));
        ArrayList<Module> modules = new ArrayList<Module>(baseModules);
        if (this.vanillaChunkSnapshotProviderFactory) {
            modules.add(new VanillaChunkSnapshotProviderFactoryModule());
        }
        if (this.vanillaRegionFileDirectoryResolver) {
            modules.add(new VanillaRegionFileDirectoryResolverModule());
        }
        modules.addAll(this.extraModules);
        return modules;
    }

    public static SquaremapModulesBuilder forPlatform(SquaremapPlatform platform) {
        return new SquaremapModulesBuilder(platform);
    }

    public static SquaremapModulesBuilder forPlatform(Class<? extends SquaremapPlatform> platformClass) {
        return new SquaremapModulesBuilder(platformClass);
    }
}

