/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.data;

import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.block.state.IBlockData;
import xyz.jpenilla.squaremap.api.LayerProvider;
import xyz.jpenilla.squaremap.api.MapWorld;
import xyz.jpenilla.squaremap.api.Registry;
import xyz.jpenilla.squaremap.api.WorldIdentifier;
import xyz.jpenilla.squaremap.common.LayerRegistry;
import xyz.jpenilla.squaremap.common.Logging;
import xyz.jpenilla.squaremap.common.config.ConfigManager;
import xyz.jpenilla.squaremap.common.config.WorldAdvanced;
import xyz.jpenilla.squaremap.common.config.WorldConfig;
import xyz.jpenilla.squaremap.common.data.BlockColors;
import xyz.jpenilla.squaremap.common.data.ChunkCoordinate;
import xyz.jpenilla.squaremap.common.data.DirectoryProvider;
import xyz.jpenilla.squaremap.common.data.Image;
import xyz.jpenilla.squaremap.common.data.LevelBiomeColorData;
import xyz.jpenilla.squaremap.common.data.RenderManager;
import xyz.jpenilla.squaremap.common.layer.SpawnIconLayer;
import xyz.jpenilla.squaremap.common.layer.WorldBorderLayer;
import xyz.jpenilla.squaremap.common.task.render.RenderFactory;
import xyz.jpenilla.squaremap.common.util.Colors;
import xyz.jpenilla.squaremap.common.util.ImageIOExecutor;
import xyz.jpenilla.squaremap.common.util.Util;
import xyz.jpenilla.squaremap.common.visibilitylimit.VisibilityLimitImpl;

public abstract class MapWorldInternal
implements MapWorld {
    private static final String DIRTY_CHUNKS_FILE_NAME = "dirty_chunks.json";
    private static final Map<WorldIdentifier, LayerRegistry> LAYER_REGISTRIES = new HashMap<WorldIdentifier, LayerRegistry>();
    private final WorldServer level;
    private final WorldConfig worldConfig;
    private final WorldAdvanced advancedWorldConfig;
    private final Path dataPath;
    private final Path tilesPath;
    private final ImageIOExecutor imageIOExecutor;
    private final RenderManager renderManager;
    private final Set<ChunkCoordinate> modifiedChunks = ConcurrentHashMap.newKeySet();
    private final BlockColors blockColors;
    private final LevelBiomeColorData levelBiomeColorData;
    private final VisibilityLimitImpl visibilityLimit;
    private volatile long lastReset = -1L;

    protected MapWorldInternal(WorldServer level, RenderFactory renderFactory, DirectoryProvider directoryProvider, ConfigManager configManager) {
        this.level = level;
        this.imageIOExecutor = ImageIOExecutor.create(level);
        this.worldConfig = configManager.worldConfig(this.level);
        this.advancedWorldConfig = configManager.worldAdvanced(this.level);
        this.blockColors = BlockColors.create(this);
        this.levelBiomeColorData = LevelBiomeColorData.create(this);
        this.dataPath = directoryProvider.getAndCreateDataDirectory(this.serverLevel());
        this.tilesPath = directoryProvider.getAndCreateTilesDirectory(this.serverLevel());
        this.layerRegistry();
        if (this.config().SPAWN_MARKER_ICON_ENABLED) {
            this.layerRegistry().register(SpawnIconLayer.KEY, new SpawnIconLayer(this));
        }
        if (this.config().WORLDBORDER_MARKER_ENABLED) {
            this.layerRegistry().register(WorldBorderLayer.KEY, new WorldBorderLayer(this));
        }
        this.visibilityLimit = new VisibilityLimitImpl(this);
        this.visibilityLimit.load(this.config().VISIBILITY_LIMITS);
        this.deserializeDirtyChunks();
        this.renderManager = RenderManager.create(this, renderFactory);
        this.renderManager.init();
    }

    @Override
    public Registry<LayerProvider> layerRegistry() {
        return LAYER_REGISTRIES.computeIfAbsent(this.identifier(), $ -> new LayerRegistry());
    }

    @Override
    public WorldIdentifier identifier() {
        return Util.worldIdentifier(this.level);
    }

    public RenderManager renderManager() {
        return this.renderManager;
    }

    public Path dataPath() {
        return this.dataPath;
    }

    public VisibilityLimitImpl visibilityLimit() {
        return this.visibilityLimit;
    }

    public LevelBiomeColorData levelBiomeColorData() {
        return this.levelBiomeColorData;
    }

    public WorldConfig config() {
        return this.worldConfig;
    }

    public WorldAdvanced advanced() {
        return this.advancedWorldConfig;
    }

    public WorldServer serverLevel() {
        return this.level;
    }

    public Path tilesPath() {
        return this.tilesPath;
    }

    public int getMapColor(IBlockData state) {
        int special = this.blockColors.color(state);
        if (special != -1) {
            return special;
        }
        return Colors.rgb(state.d(null, null));
    }

    public void saveImage(Image image) {
        this.imageIOExecutor.saveImage(image);
    }

    public void chunkModified(ChunkCoordinate coord) {
        if (!this.config().BACKGROUND_RENDER_ENABLED) {
            return;
        }
        if (!this.visibilityLimit().shouldRenderChunk(coord)) {
            return;
        }
        this.modifiedChunks.add(coord);
    }

    public boolean hasModifiedChunks() {
        return !this.modifiedChunks.isEmpty();
    }

    public ChunkCoordinate nextModifiedChunk() {
        Iterator<ChunkCoordinate> it = this.modifiedChunks.iterator();
        ChunkCoordinate coord = it.next();
        it.remove();
        return coord;
    }

    public void shutdown() {
        if (this.layerRegistry().hasEntry(SpawnIconLayer.KEY)) {
            this.layerRegistry().unregister(SpawnIconLayer.KEY);
        }
        if (this.layerRegistry().hasEntry(WorldBorderLayer.KEY)) {
            this.layerRegistry().unregister(WorldBorderLayer.KEY);
        }
        this.renderManager.shutdown();
        this.imageIOExecutor.shutdown();
        this.serializeDirtyChunks();
    }

    private void serializeDirtyChunks() {
        Path file = this.dataPath.resolve(DIRTY_CHUNKS_FILE_NAME);
        if (this.modifiedChunks.size() > 200000) {
            Logging.logger().warn("Map for world '{}' has a large amount ({}) of chunks queued for background render! If this notice appears frequently, consider adjusting the background render and or update trigger settings.", (Object)this.identifier().asString(), (Object)this.modifiedChunks.size());
        }
        try {
            Files.writeString(file, (CharSequence)Util.gson().toJson(this.modifiedChunks), new OpenOption[0]);
        }
        catch (IOException ex) {
            Logging.logger().warn("Failed to serialize dirty chunks for world '{}' to file '{}'", (Object)this.identifier().asString(), (Object)file, (Object)ex);
        }
    }

    private void deserializeDirtyChunks() {
        List deserialized;
        Path file = this.dataPath.resolve(DIRTY_CHUNKS_FILE_NAME);
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(file);){
            deserialized = (List)Util.gson().fromJson((Reader)reader, new TypeToken<List<ChunkCoordinate>>(){}.getType());
        }
        catch (JsonIOException | JsonSyntaxException | IOException ex) {
            Logging.logger().warn("Failed to deserialize dirty chunks for world '{}' from file '{}'", (Object)this.identifier().asString(), (Object)file, (Object)ex);
            return;
        }
        if (deserialized == null) {
            Logging.logger().warn("Failed to deserialize dirty chunks for world '{}' from file '{}' (null result, file is corrupted or empty?)", (Object)this.identifier().asString(), (Object)file);
            return;
        }
        this.modifiedChunks.addAll(deserialized);
    }

    public void didReset() {
        this.lastReset = System.currentTimeMillis();
    }

    public long lastReset() {
        return this.lastReset;
    }

    public static interface Factory {
        public MapWorldInternal create(WorldServer var1);
    }
}

