/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.data;

import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMaps;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.Path;
import java.util.Arrays;
import javax.imageio.ImageIO;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.ICombinedAccess;
import net.minecraft.world.level.biome.BiomeBase;
import xyz.jpenilla.squaremap.common.data.DirectoryProvider;
import xyz.jpenilla.squaremap.common.data.MapWorldInternal;
import xyz.jpenilla.squaremap.common.util.Colors;
import xyz.jpenilla.squaremap.common.util.Util;

public record LevelBiomeColorData(Reference2IntMap<BiomeBase> grassColors, Reference2IntMap<BiomeBase> foliageColors, Reference2IntMap<BiomeBase> waterColors) {
    private static int[] MAP_GRASS;
    private static int[] MAP_FOLIAGE;

    public static void loadImages(DirectoryProvider directoryProvider) {
        BufferedImage imgFoliage;
        BufferedImage imgGrass;
        Path imagesDir = directoryProvider.webDirectory().resolve("images");
        try {
            imgGrass = ImageIO.read(imagesDir.resolve("grass.png").toFile());
            imgFoliage = ImageIO.read(imagesDir.resolve("foliage.png").toFile());
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read biome images", e);
        }
        MAP_GRASS = LevelBiomeColorData.toArray(imgGrass);
        MAP_FOLIAGE = LevelBiomeColorData.toArray(imgFoliage);
    }

    public static LevelBiomeColorData create(MapWorldInternal world) {
        Reference2IntOpenHashMap grassColors = new Reference2IntOpenHashMap();
        Reference2IntOpenHashMap foliageColors = new Reference2IntOpenHashMap();
        Reference2IntOpenHashMap waterColors = new Reference2IntOpenHashMap();
        for (BiomeBase biome : Util.biomeRegistry((ICombinedAccess)world.serverLevel())) {
            float temperature = MathHelper.a((float)biome.g(), (float)0.0f, (float)1.0f);
            float humidity = MathHelper.a((float)LevelBiomeColorData.downfall(biome), (float)0.0f, (float)1.0f);
            grassColors.put((Object)biome, biome.h().f().orElse(LevelBiomeColorData.defaultGrassColor(temperature, humidity)).intValue());
            foliageColors.put((Object)biome, biome.h().e().orElse(Colors.mix(Colors.plantMapColor(), LevelBiomeColorData.defaultFoliageColor(temperature, humidity), 0.85f)).intValue());
            waterColors.put((Object)biome, biome.h().b());
        }
        grassColors.putAll(world.advanced().COLOR_OVERRIDES_BIOME_GRASS);
        foliageColors.putAll(world.advanced().COLOR_OVERRIDES_BIOME_FOLIAGE);
        waterColors.putAll(world.advanced().COLOR_OVERRIDES_BIOME_WATER);
        return new LevelBiomeColorData((Reference2IntMap<BiomeBase>)Reference2IntMaps.unmodifiable((Reference2IntMap)grassColors), (Reference2IntMap<BiomeBase>)Reference2IntMaps.unmodifiable((Reference2IntMap)foliageColors), (Reference2IntMap<BiomeBase>)Reference2IntMaps.unmodifiable((Reference2IntMap)waterColors));
    }

    private static float downfall(BiomeBase biome) {
        Field climateSettingsField = Arrays.stream(biome.getClass().getDeclaredFields()).filter(it -> !Modifier.isStatic(it.getModifiers())).findFirst().orElseThrow();
        climateSettingsField.setAccessible(true);
        float downfall = Float.MAX_VALUE;
        try {
            Object climateSettings = climateSettingsField.get(biome);
            int count = 0;
            for (Method m : climateSettings.getClass().getDeclaredMethods()) {
                if (m.getReturnType() != Float.TYPE || ++count != 2) continue;
                downfall = ((Float)m.invoke(climateSettings, new Object[0])).floatValue();
                break;
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        if (downfall == Float.MAX_VALUE) {
            throw new IllegalStateException("Could not determine 'downfall' for biome: " + biome);
        }
        return downfall;
    }

    private static int[] toArray(BufferedImage image) {
        int[] array = new int[65536];
        for (int x = 0; x < 256; ++x) {
            for (int y = 0; y < 256; ++y) {
                int color = image.getRGB(x, y);
                int r = color >> 16 & 0xFF;
                int g = color >> 8 & 0xFF;
                int b = color & 0xFF;
                array[x + y * 256] = 0xFF000000 | r << 16 | g << 8 | b;
            }
        }
        return array;
    }

    private static int defaultGrassColor(double temperature, double humidity) {
        int j = (int)((1.0 - humidity * temperature) * 255.0);
        int i = (int)((1.0 - temperature) * 255.0);
        int k = j << 8 | i;
        if (k > MAP_GRASS.length) {
            return 0;
        }
        return MAP_GRASS[k];
    }

    private static int defaultFoliageColor(double temperature, double humidity) {
        int i = (int)((1.0 - temperature) * 255.0);
        int j = (int)((1.0 - humidity * temperature) * 255.0);
        return MAP_FOLIAGE[j << 8 | i];
    }
}

