/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.data;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import net.minecraft.util.MathHelper;
import org.checkerframework.checker.nullness.qual.Nullable;
import xyz.jpenilla.squaremap.common.Logging;
import xyz.jpenilla.squaremap.common.config.Config;
import xyz.jpenilla.squaremap.common.config.Messages;
import xyz.jpenilla.squaremap.common.data.RegionCoordinate;
import xyz.jpenilla.squaremap.common.util.FileUtil;

public final class Image {
    private static final int TRANSPARENT = new Color(0, 0, 0, 0).getRGB();
    public static final int SIZE = 512;
    private final RegionCoordinate region;
    private final Path directory;
    private final int maxZoom;
    private int @Nullable [][] pixels = null;

    public Image(RegionCoordinate region, Path directory, int maxZoom) {
        this.region = region;
        this.directory = directory;
        this.maxZoom = maxZoom;
    }

    public synchronized void setPixel(int x, int z, int color) {
        if (this.pixels == null) {
            for (int[] arr : this.pixels = new int[512][512]) {
                Arrays.fill(arr, Integer.MIN_VALUE);
            }
        }
        this.pixels[x & 0x1FF][z & 0x1FF] = color;
    }

    public synchronized void save() {
        if (this.pixels == null) {
            return;
        }
        for (int zoom = 0; zoom <= this.maxZoom; ++zoom) {
            int step = (int)Math.pow(2.0, zoom);
            int size = 512 / step;
            int scaledX = MathHelper.a((double)((double)this.region.x() / (double)step));
            int scaledZ = MathHelper.a((double)((double)this.region.z() / (double)step));
            BufferedImage image = this.getOrCreate(this.maxZoom - zoom, scaledX, scaledZ);
            int baseX = this.region.x() * size & 0x1FF;
            int baseZ = this.region.z() * size & 0x1FF;
            for (int x = 0; x < 512; x += step) {
                for (int z = 0; z < 512; z += step) {
                    int pixel = this.pixels[x][z];
                    if (pixel == Integer.MIN_VALUE) continue;
                    int color = pixel == 0 ? TRANSPARENT : pixel;
                    image.setRGB(baseX + x / step, baseZ + z / step, color);
                }
            }
            this.save(this.maxZoom - zoom, scaledX, scaledZ, image);
        }
    }

    private BufferedImage getOrCreate(int zoom, int scaledX, int scaledZ) {
        Path file = this.imageInDirectory(zoom, scaledX, scaledZ);
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            return Image.newBufferedImage();
        }
        try {
            @Nullable BufferedImage read = ImageIO.read(file.toFile());
            if (read == null) {
                throw new IOException("Failed to read image file '" + file.toAbsolutePath() + "', ImageIO.read(File) result is null. This means no supported image format was able to read it. The image file may have been malformed or corrupted, it will be overwritten.");
            }
            return read;
        }
        catch (IOException ex) {
            try {
                Files.deleteIfExists(file);
            }
            catch (IOException ex0) {
                ex.addSuppressed(ex0);
            }
            this.logCouldNotRead(ex);
            return Image.newBufferedImage();
        }
    }

    private void save(int zoom, int scaledX, int scaledZ, BufferedImage image) {
        Path out = this.imageInDirectory(zoom, scaledX, scaledZ);
        try {
            FileUtil.atomicWrite(out, tmp -> {
                try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(tmp, new OpenOption[0]));){
                    Image.save(image, outputStream);
                }
            });
        }
        catch (IOException ex) {
            this.logCouldNotSave(ex);
        }
    }

    private static void save(BufferedImage image, OutputStream out) throws IOException {
        ImageWriter writer = ImageIO.getImageWritersByFormatName("png").next();
        try (ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(out);){
            writer.setOutput(imageOutputStream);
            ImageWriteParam param = writer.getDefaultWriteParam();
            if (Config.COMPRESS_IMAGES && param.canWriteCompressed()) {
                param.setCompressionMode(2);
                if (param.getCompressionType() == null) {
                    param.setCompressionType(param.getCompressionTypes()[0]);
                }
                param.setCompressionQuality(Config.COMPRESSION_RATIO);
            }
            writer.write(null, new IIOImage(image, null, null), param);
        }
    }

    private Path imageInDirectory(int zoom, int scaledX, int scaledZ) {
        Path dir = this.directory.resolve(Integer.toString(zoom));
        if (!Files.exists(dir, new LinkOption[0])) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(Logging.replace(Messages.LOG_COULD_NOT_CREATE_DIR, "path", dir.toAbsolutePath()), e);
            }
        }
        String fileName = scaledX + "_" + scaledZ + ".png";
        return dir.resolve(fileName);
    }

    private static BufferedImage newBufferedImage() {
        return new BufferedImage(512, 512, 2);
    }

    private void logCouldNotRead(IOException ex) {
        Logging.logger().error(this.xz(Messages.LOG_COULD_NOT_READ_REGION), (Throwable)ex);
    }

    private void logCouldNotSave(IOException ex) {
        Logging.logger().error(this.xz(Messages.LOG_COULD_NOT_SAVE_REGION), (Throwable)ex);
    }

    private String xz(String s) {
        return Logging.replace(s, "x", this.region.x(), "z", this.region.z());
    }
}

