/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.data;

import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMaps;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.HashMap;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCrops;
import net.minecraft.world.level.block.BlockStem;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.IBlockState;
import org.checkerframework.checker.nullness.qual.Nullable;
import xyz.jpenilla.squaremap.common.data.MapWorldInternal;
import xyz.jpenilla.squaremap.common.util.Colors;

public final class BlockColors {
    private final Reference2IntMap<Block> staticColorMap;
    private final Reference2ObjectMap<Block, DynamicColorGetter> dynamicColorMap;

    private BlockColors(MapWorldInternal world) {
        Reference2IntOpenHashMap staticColors = new Reference2IntOpenHashMap(world.advanced().COLOR_OVERRIDES_BLOCKS);
        staticColors.defaultReturnValue(-1);
        this.staticColorMap = Reference2IntMaps.unmodifiable((Reference2IntMap)staticColors);
        this.dynamicColorMap = this.loadDynamicColors();
    }

    private Reference2ObjectMap<Block, DynamicColorGetter> loadDynamicColors() {
        HashMap<Block, DynamicColorGetter> map = new HashMap<Block, DynamicColorGetter>();
        map.put(Blocks.fe, BlockColors::melonAndPumpkinStem);
        map.put(Blocks.fd, BlockColors::melonAndPumpkinStem);
        map.put(Blocks.cB, BlockColors::wheat);
        return Reference2ObjectMaps.unmodifiable((Reference2ObjectMap)new Reference2ObjectOpenHashMap(map));
    }

    public int color(IBlockData state) {
        Block block = state.b();
        int staticColor = this.staticColorMap.getInt((Object)block);
        if (staticColor != -1) {
            return staticColor;
        }
        @Nullable DynamicColorGetter func = (DynamicColorGetter)this.dynamicColorMap.get((Object)block);
        if (func != null) {
            return func.color(state);
        }
        return -1;
    }

    private static int melonAndPumpkinStem(IBlockData state) {
        int age = (Integer)state.c((IBlockState)BlockStem.b);
        int k = age * 32;
        int l = 255 - age * 8;
        int m = age * 4;
        return k << 16 | l << 8 | m;
    }

    private static int wheat(IBlockData state) {
        float factor = (float)((Integer)state.c((IBlockState)BlockCrops.d) + 1) / 8.0f;
        return Colors.mix(Colors.plantMapColor(), 14465893, factor);
    }

    public static BlockColors create(MapWorldInternal mapWorld) {
        return new BlockColors(mapWorld);
    }

    @FunctionalInterface
    private static interface DynamicColorGetter {
        public int color(IBlockData var1);
    }
}

