/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.data;

import it.unimi.dsi.fastutil.longs.Long2ReferenceLinkedOpenHashMap;
import java.util.Set;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.MaterialMapColor;
import org.checkerframework.checker.nullness.qual.Nullable;
import xyz.jpenilla.squaremap.common.data.LevelBiomeColorData;
import xyz.jpenilla.squaremap.common.data.MapWorldInternal;
import xyz.jpenilla.squaremap.common.task.render.AbstractRender;
import xyz.jpenilla.squaremap.common.util.ColorBlender;
import xyz.jpenilla.squaremap.common.util.Colors;
import xyz.jpenilla.squaremap.common.util.chunksnapshot.ChunkSnapshot;

public final class BiomeColors {
    private static final int BLOCKPOS_BIOME_CACHE_SIZE = 4096;
    private static final Set<Block> GRASS_COLOR_BLOCKS = Set.of(Blocks.i, Blocks.bt, Blocks.iH, Blocks.bu, Blocks.iI, Blocks.gb, Blocks.dS);
    private static final Set<Block> FOLIAGE_COLOR_BLOCKS = Set.of(Blocks.ff, Blocks.aE, Blocks.aH, Blocks.aI, Blocks.aK, Blocks.aL);
    private final ColorBlender colorBlender = new ColorBlender();
    private final BlockPosition.MutableBlockPosition mutablePos = new BlockPosition.MutableBlockPosition();
    private final LevelBiomeColorData colorData;
    private final MapWorldInternal world;
    private final BiomeCache biomeCache;

    public BiomeColors(MapWorldInternal world, AbstractRender.ChunkSnapshotManager chunkSnapshotProvider) {
        this.world = world;
        this.colorData = world.levelBiomeColorData();
        this.biomeCache = BiomeCache.sized(this.world.serverLevel(), chunkSnapshotProvider, 4096);
    }

    public int modifyColorFromBiome(int color, ChunkSnapshot chunk, BlockPosition pos) {
        IBlockData data = chunk.getBlockState(pos);
        Block block = data.b();
        if (GRASS_COLOR_BLOCKS.contains(block)) {
            color = this.grass(pos);
        } else if (FOLIAGE_COLOR_BLOCKS.contains(block)) {
            color = this.foliage(pos);
        } else if (block.s() == MaterialMapColor.m) {
            int modColor = this.water(pos);
            color = Colors.mix(color, modColor, 0.8f);
        }
        return color;
    }

    private int grass(BlockPosition pos) {
        if (this.world.config().MAP_BIOMES_BLEND > 0) {
            return this.sampleNeighbors(pos, this.world.config().MAP_BIOMES_BLEND, this::grassColorSampler);
        }
        return this.grassColorSampler(this.biome(pos), pos);
    }

    private int grassColorSampler(BiomeBase biome, BlockPosition pos) {
        return biome.h().g().a((double)pos.u(), (double)pos.w(), this.colorData.grassColors().getInt((Object)biome));
    }

    private int foliage(BlockPosition pos) {
        if (this.world.config().MAP_BIOMES_BLEND > 0) {
            return this.sampleNeighbors(pos, this.world.config().MAP_BIOMES_BLEND, (biome, b) -> this.colorData.foliageColors().getInt((Object)biome));
        }
        return this.colorData.foliageColors().getInt((Object)this.biome(pos));
    }

    private int water(BlockPosition pos) {
        if (this.world.config().MAP_BIOMES_BLEND > 0) {
            return this.sampleNeighbors(pos, this.world.config().MAP_BIOMES_BLEND, (biome, b) -> this.colorData.waterColors().getInt((Object)biome));
        }
        return this.colorData.waterColors().getInt((Object)this.biome(pos));
    }

    private int sampleNeighbors(BlockPosition pos, int radius, ColorSampler colorSampler) {
        this.colorBlender.reset();
        for (int x = pos.u() - radius; x < pos.u() + radius; ++x) {
            for (int z = pos.w() - radius; z < pos.w() + radius; ++z) {
                this.mutablePos.d(x, pos.v(), z);
                this.colorBlender.addColor(colorSampler.sample(this.biome((BlockPosition)this.mutablePos), (BlockPosition)this.mutablePos));
            }
        }
        return this.colorBlender.result();
    }

    private BiomeBase biome(BlockPosition pos) {
        return this.biomeCache.biome(pos);
    }

    private static final class BiomeCache {
        private final WorldServer level;
        private final AbstractRender.ChunkSnapshotManager chunkSnapshotManager;
        private final int size;
        private final Long2ReferenceLinkedOpenHashMap<BiomeBase> cache;
        private final BiomeManager biomeManager;

        private BiomeCache(WorldServer level, AbstractRender.ChunkSnapshotManager chunkSnapshotManager, int size) {
            this.level = level;
            this.chunkSnapshotManager = chunkSnapshotManager;
            this.size = size;
            this.cache = new Long2ReferenceLinkedOpenHashMap(size);
            this.biomeManager = this.level.E_().a(this::noiseBiome);
        }

        public BiomeBase biome(BlockPosition pos) {
            long blockKey = pos.a();
            @Nullable BiomeBase cached = (BiomeBase)this.cache.get(blockKey);
            if (cached != null) {
                return cached;
            }
            BiomeBase biome = (BiomeBase)this.biomeManager.a(pos).a();
            if (this.cache.size() >= this.size) {
                this.cache.removeLast();
            }
            this.cache.putAndMoveToFirst(blockKey, (Object)biome);
            return biome;
        }

        private Holder<BiomeBase> noiseBiome(int quartX, int quartY, int quartZ) {
            ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(QuartPos.e((int)quartX), QuartPos.e((int)quartZ));
            @Nullable ChunkSnapshot chunk = this.chunkSnapshotManager.snapshotDirect(chunkPos).join();
            ChunkSnapshot noiseBiomeSource = chunk == null ? (arg_0, arg_1, arg_2) -> ((WorldServer)this.level).a(arg_0, arg_1, arg_2) : chunk;
            return noiseBiomeSource.getNoiseBiome(quartX, quartY, quartZ);
        }

        public static BiomeCache sized(WorldServer level, AbstractRender.ChunkSnapshotManager snapshotCache, int size) {
            return new BiomeCache(level, snapshotCache, size);
        }
    }

    @FunctionalInterface
    static interface ColorSampler {
        public int sample(BiomeBase var1, BlockPosition var2);
    }
}

