/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.config;

import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.ICombinedAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import squaremap.libraries.io.leangen.geantyref.TypeToken;
import xyz.jpenilla.squaremap.common.config.AbstractWorldConfig;
import xyz.jpenilla.squaremap.common.config.Advanced;
import xyz.jpenilla.squaremap.common.util.Colors;
import xyz.jpenilla.squaremap.common.util.Util;

public final class WorldAdvanced
extends AbstractWorldConfig<Advanced> {
    public final Set<Block> invisibleBlocks = new HashSet<Block>();
    public final Set<Block> iterateUpBaseBlocks = new HashSet<Block>();
    public final Reference2IntMap<BiomeBase> COLOR_OVERRIDES_BIOME_FOLIAGE = new Reference2IntOpenHashMap();
    public final Reference2IntMap<BiomeBase> COLOR_OVERRIDES_BIOME_GRASS = new Reference2IntOpenHashMap();
    public final Reference2IntMap<BiomeBase> COLOR_OVERRIDES_BIOME_WATER = new Reference2IntOpenHashMap();
    public final Reference2IntMap<Block> COLOR_OVERRIDES_BLOCKS = new Reference2IntOpenHashMap();

    WorldAdvanced(Advanced parent, WorldServer level) {
        super(WorldAdvanced.class, parent, level);
        this.init();
    }

    private void invisibleBlocks() {
        this.invisibleBlocks.clear();
        this.getStringList("invisible-blocks", List.of("minecraft:tall_grass", "minecraft:fern", "minecraft:grass", "minecraft:large_fern")).forEach(block -> this.invisibleBlocks.add((Block)Util.requireEntry(BuiltInRegistries.f, new MinecraftKey(block))));
    }

    private void iterateUpBaseBlocks() {
        this.iterateUpBaseBlocks.clear();
        this.getStringList("iterate-up-base-blocks", List.of("minecraft:netherrack", "minecraft:glowstone", "minecraft:soul_sand", "minecraft:soul_soil", "minecraft:gravel", "minecraft:warped_nylium", "minecraft:crimson_nylium", "minecraft:nether_gold_ore", "minecraft:ancient_debris", "minecraft:nether_quartz_ore", "minecraft:magma_block", "minecraft:basalt")).forEach(block -> this.iterateUpBaseBlocks.add((Block)Util.requireEntry(BuiltInRegistries.f, new MinecraftKey(block))));
    }

    private void colorOverrideBiomeFoliageSettings() {
        IRegistry<BiomeBase> registry = Util.biomeRegistry((ICombinedAccess)this.world);
        this.COLOR_OVERRIDES_BIOME_FOLIAGE.clear();
        this.get(new TypeToken<Map<String, String>>(){}, "color-overrides.biomes.foliage", Map.ofEntries(Map.entry("minecraft:dark_forest", "#1c7b07"), Map.entry("minecraft:jungle", "#1f8907"), Map.entry("minecraft:sparse_jungle", "#1f8907"), Map.entry("minecraft:bamboo_jungle", "#1f8907"), Map.entry("minecraft:mangrove_swamp", "#6f9623"))).forEach((key, color) -> {
            BiomeBase biome = (BiomeBase)Util.requireEntry(registry, new MinecraftKey(key));
            this.COLOR_OVERRIDES_BIOME_FOLIAGE.put((Object)biome, Colors.parseHex(color));
        });
    }

    private void colorOverrideBiomeGrassSettings() {
        IRegistry<BiomeBase> registry = Util.biomeRegistry((ICombinedAccess)this.world);
        this.COLOR_OVERRIDES_BIOME_GRASS.clear();
        this.get(new TypeToken<Map<String, String>>(){}, "color-overrides.biomes.grass", Map.of()).forEach((key, color) -> {
            BiomeBase biome = (BiomeBase)Util.requireEntry(registry, new MinecraftKey(key));
            this.COLOR_OVERRIDES_BIOME_GRASS.put((Object)biome, Colors.parseHex(color));
        });
    }

    private void colorOverrideBiomeWaterSettings() {
        IRegistry<BiomeBase> registry = Util.biomeRegistry((ICombinedAccess)this.world);
        this.COLOR_OVERRIDES_BIOME_WATER.clear();
        this.get(new TypeToken<Map<String, String>>(){}, "color-overrides.biomes.water", Map.of()).forEach((key, color) -> {
            BiomeBase biome = (BiomeBase)Util.requireEntry(registry, new MinecraftKey(key));
            this.COLOR_OVERRIDES_BIOME_WATER.put((Object)biome, Colors.parseHex(color));
        });
    }

    private void colorOverrideBlocksSettings() {
        this.COLOR_OVERRIDES_BLOCKS.clear();
        this.get(new TypeToken<Map<String, String>>(){}, "color-overrides.blocks", Map.ofEntries(Map.entry("minecraft:mycelium", "#6F6265"), Map.entry("minecraft:terracotta", "#9E6246"), Map.entry("minecraft:pink_petals", "#FFB4DB"), Map.entry("minecraft:dandelion", "#FFEC4F"), Map.entry("minecraft:poppy", "#ED302C"), Map.entry("minecraft:blue_orchid", "#2ABFFD"), Map.entry("minecraft:allium", "#B878ED"), Map.entry("minecraft:azure_bluet", "#F7F7F7"), Map.entry("minecraft:red_tulip", "#9B221A"), Map.entry("minecraft:orange_tulip", "#BD6A22"), Map.entry("minecraft:pink_tulip", "#EBC5FD"), Map.entry("minecraft:white_tulip", "#D6E8E8"), Map.entry("minecraft:oxeye_daisy", "#D6E8E8"), Map.entry("minecraft:cornflower", "#466AEB"), Map.entry("minecraft:lily_of_the_valley", "#FFFFFF"), Map.entry("minecraft:wither_rose", "#211A16"), Map.entry("minecraft:sunflower", "#FFEC4F"), Map.entry("minecraft:lilac", "#B66BB2"), Map.entry("minecraft:rose_bush", "#9B221A"), Map.entry("minecraft:peony", "#EBC5FD"), Map.entry("minecraft:lily_pad", "#208030"), Map.entry("minecraft:attached_melon_stem", "#E0C71C"), Map.entry("minecraft:attached_pumpkin_stem", "#E0C71C"), Map.entry("minecraft:spruce_leaves", "#619961"), Map.entry("minecraft:birch_leaves", "#80A755"), Map.entry("minecraft:lava", "#EA5C0F"), Map.entry("minecraft:glass", "#FFFFFF"))).forEach((key, color) -> {
            Block block = (Block)Util.requireEntry(BuiltInRegistries.f, new MinecraftKey(key));
            if (block != Blocks.a) {
                this.COLOR_OVERRIDES_BLOCKS.put((Object)block, Colors.parseHex(color));
            }
        });
    }
}

