/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.config;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.server.level.WorldServer;
import squaremap.libraries.com.google.inject.Inject;
import squaremap.libraries.com.google.inject.Singleton;
import xyz.jpenilla.squaremap.api.WorldIdentifier;
import xyz.jpenilla.squaremap.common.ServerAccess;
import xyz.jpenilla.squaremap.common.config.AbstractConfig;
import xyz.jpenilla.squaremap.common.config.AbstractWorldConfig;
import xyz.jpenilla.squaremap.common.config.Advanced;
import xyz.jpenilla.squaremap.common.config.Config;
import xyz.jpenilla.squaremap.common.config.Messages;
import xyz.jpenilla.squaremap.common.config.WorldAdvanced;
import xyz.jpenilla.squaremap.common.config.WorldConfig;
import xyz.jpenilla.squaremap.common.data.DirectoryProvider;
import xyz.jpenilla.squaremap.common.util.SquaremapJarAccess;
import xyz.jpenilla.squaremap.common.util.Util;

@Singleton
public final class ConfigManager {
    private final DirectoryProvider directoryProvider;
    private final SquaremapJarAccess squaremapJar;
    private final WorldConfigContainer<WorldConfig, Config> worldConfigContainer;
    private final WorldConfigContainer<WorldAdvanced, Advanced> worldAdvancedContainer;

    @Inject
    private ConfigManager(DirectoryProvider directoryProvider, SquaremapJarAccess squaremapJar, ServerAccess serverAccess) {
        this.directoryProvider = directoryProvider;
        this.squaremapJar = squaremapJar;
        this.worldConfigContainer = new WorldConfigContainer<WorldConfig, Config>(WorldConfig::new, Config::config, serverAccess);
        this.worldAdvancedContainer = new WorldConfigContainer<WorldAdvanced, Advanced>(WorldAdvanced::new, Advanced::config, serverAccess);
    }

    public void init() {
        this.reload();
    }

    public void reload() {
        Config.reload(this.directoryProvider);
        this.worldConfigContainer.reload();
        Advanced.reload(this.directoryProvider);
        this.worldAdvancedContainer.reload();
        Messages.reload(this.squaremapJar, this.directoryProvider);
    }

    public WorldConfig worldConfig(WorldServer level) {
        return this.worldConfigContainer.config(level);
    }

    public WorldAdvanced worldAdvanced(WorldServer level) {
        return this.worldAdvancedContainer.config(level);
    }

    private static final class WorldConfigContainer<W extends AbstractWorldConfig<P>, P extends AbstractConfig> {
        private final Map<WorldIdentifier, W> configs = new ConcurrentHashMap<WorldIdentifier, W>();
        private final BiFunction<P, WorldServer, W> worldConfigFactory;
        private final Supplier<P> parentConfigSupplier;
        private final ServerAccess serverAccess;

        WorldConfigContainer(BiFunction<P, WorldServer, W> worldConfigFactory, Supplier<P> parentConfigSupplier, ServerAccess serverAccess) {
            this.worldConfigFactory = worldConfigFactory;
            this.parentConfigSupplier = parentConfigSupplier;
            this.serverAccess = serverAccess;
        }

        void reload() {
            this.configs.clear();
            for (WorldServer level : this.serverAccess.levels()) {
                this.configs.put(Util.worldIdentifier(level), this.create(level));
            }
        }

        W config(WorldServer level) {
            return (W)this.configs.computeIfAbsent(Util.worldIdentifier(level), $ -> this.create(level));
        }

        W create(WorldServer level) {
            return (W)((AbstractWorldConfig)this.worldConfigFactory.apply((AbstractConfig)this.parentConfigSupplier.get(), level));
        }
    }
}

