/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.config;

import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.server.level.WorldServer;
import org.checkerframework.checker.nullness.qual.Nullable;
import squaremap.libraries.io.leangen.geantyref.TypeToken;
import xyz.jpenilla.squaremap.common.config.AbstractConfig;
import xyz.jpenilla.squaremap.common.config.Config;
import xyz.jpenilla.squaremap.common.util.ReflectionUtil;
import xyz.jpenilla.squaremap.common.util.Util;

public abstract class AbstractWorldConfig<P extends AbstractConfig> {
    public static final String DOT = "____dot____";
    private static final @Nullable Class<?> PAPER_MIGRATION_CLASS = ReflectionUtil.findClass("xyz.jpenilla.squaremap.paper.util.WorldNameToKeyMigration");
    private static final @Nullable Method PAPER_MIGRATE_METHOD = PAPER_MIGRATION_CLASS == null ? null : ReflectionUtil.needMethod(PAPER_MIGRATION_CLASS, List.of("migrate"), AbstractConfig.class, WorldServer.class);
    final String worldName;
    protected final WorldServer world;
    protected final P parent;
    private final Class<? extends AbstractWorldConfig<P>> configClass;

    protected AbstractWorldConfig(Class<? extends AbstractWorldConfig<P>> worldConfigClass, P parent, WorldServer level) {
        this.configClass = worldConfigClass;
        this.world = level;
        this.worldName = Util.levelConfigName(level).replace(".", DOT);
        this.parent = parent;
        if (PAPER_MIGRATE_METHOD != null) {
            ReflectionUtil.invokeOrThrow(PAPER_MIGRATE_METHOD, null, parent, level);
        }
    }

    protected final void init() {
        ((AbstractConfig)this.parent).readConfig(this.configClass, this);
    }

    protected final boolean getBoolean(String path, boolean def) {
        if (this.virtual(this.wrapPath(path))) {
            return ((AbstractConfig)this.parent).getBoolean(AbstractWorldConfig.wrapDefaultPath(path), def);
        }
        return ((AbstractConfig)this.parent).getBoolean(this.wrapPath(path), ((AbstractConfig)this.parent).getBoolean(AbstractWorldConfig.wrapDefaultPath(path), def));
    }

    protected final int getInt(String path, int def) {
        if (this.virtual(this.wrapPath(path))) {
            return ((AbstractConfig)this.parent).getInt(AbstractWorldConfig.wrapDefaultPath(path), def);
        }
        return ((AbstractConfig)this.parent).getInt(this.wrapPath(path), ((AbstractConfig)this.parent).getInt(AbstractWorldConfig.wrapDefaultPath(path), def));
    }

    protected final double getDouble(String path, double def) {
        if (this.virtual(this.wrapPath(path))) {
            return ((AbstractConfig)this.parent).getDouble(AbstractWorldConfig.wrapDefaultPath(path), def);
        }
        return ((AbstractConfig)this.parent).getDouble(this.wrapPath(path), ((AbstractConfig)this.parent).getDouble(AbstractWorldConfig.wrapDefaultPath(path), def));
    }

    protected final String getString(String path, String def) {
        if (this.virtual(this.wrapPath(path))) {
            return ((AbstractConfig)this.parent).getString(AbstractWorldConfig.wrapDefaultPath(path), def);
        }
        return ((AbstractConfig)this.parent).getString(this.wrapPath(path), ((AbstractConfig)this.parent).getString(AbstractWorldConfig.wrapDefaultPath(path), def));
    }

    protected final <T> List<T> getList(TypeToken<T> elementType, String path, List<T> def) {
        if (this.virtual(this.wrapPath(path))) {
            return ((AbstractConfig)this.parent).getList(elementType, AbstractWorldConfig.wrapDefaultPath(path), def);
        }
        return ((AbstractConfig)this.parent).getList(elementType, this.wrapPath(path), ((AbstractConfig)this.parent).getList(elementType, AbstractWorldConfig.wrapDefaultPath(path), def));
    }

    protected final <T> List<T> getList(Class<T> elementType, String path, List<T> def) {
        return this.getList(TypeToken.get(elementType), path, def);
    }

    protected final List<String> getStringList(String path, List<String> def) {
        return this.getList(String.class, path, def);
    }

    protected final <T> T get(TypeToken<T> type, String path, T def) {
        if (this.virtual(this.wrapPath(path))) {
            return ((AbstractConfig)this.parent).get(type, AbstractWorldConfig.wrapDefaultPath(path), def);
        }
        return ((AbstractConfig)this.parent).get(type, this.wrapPath(path), ((AbstractConfig)this.parent).get(type, AbstractWorldConfig.wrapDefaultPath(path), def));
    }

    private boolean virtual(String path) {
        return ((AbstractConfig)this.parent).config.node(Config.splitPath(path)).virtual();
    }

    private String wrapPath(String path) {
        return "world-settings." + this.worldName + "." + path;
    }

    private static String wrapDefaultPath(String path) {
        return "world-settings.default." + path;
    }
}

