/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.config;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import net.minecraft.server.level.WorldServer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import squaremap.libraries.io.leangen.geantyref.TypeFactory;
import squaremap.libraries.io.leangen.geantyref.TypeToken;
import squaremap.libraries.org.spongepowered.configurate.CommentedConfigurationNode;
import squaremap.libraries.org.spongepowered.configurate.ConfigurateException;
import squaremap.libraries.org.spongepowered.configurate.ConfigurationNode;
import squaremap.libraries.org.spongepowered.configurate.loader.ConfigurationLoader;
import squaremap.libraries.org.spongepowered.configurate.serialize.SerializationException;
import squaremap.libraries.org.spongepowered.configurate.transformation.ConfigurationTransformation;
import squaremap.libraries.org.spongepowered.configurate.yaml.NodeStyle;
import squaremap.libraries.org.spongepowered.configurate.yaml.YamlConfigurationLoader;
import xyz.jpenilla.squaremap.common.Logging;
import xyz.jpenilla.squaremap.common.config.ConfigUpgrader;
import xyz.jpenilla.squaremap.common.util.Util;
import xyz.jpenilla.squaremap.common.visibilitylimit.VisibilityShape;
import xyz.jpenilla.squaremap.common.visibilitylimit.VisibilityShapeSerializer;

public abstract class AbstractConfig {
    final Path configFile;
    final ConfigurationNode config;
    private final ConfigurationLoader<CommentedConfigurationNode> loader;
    private final Class<? extends AbstractConfig> configClass;
    private final int latestVersion;

    protected AbstractConfig(Path dataDirectory, Class<? extends AbstractConfig> configClass, String filename, int latestVersion) {
        this.latestVersion = latestVersion;
        this.configClass = configClass;
        this.configFile = dataDirectory.resolve(filename);
        this.loader = ((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(this.configFile)).nodeStyle(NodeStyle.BLOCK).defaultOptions(opts -> opts.serializers(serializers -> serializers.register(VisibilityShape.class, new VisibilityShapeSerializer())))).build();
        try {
            this.config = this.loader.load();
        }
        catch (ConfigurateException ex) {
            throw new RuntimeException("Could not load config.yml, exception occurred (are there syntax errors?)", ex);
        }
        this.upgradeConfig();
    }

    protected void addVersions(ConfigurationTransformation.VersionedBuilder versionedBuilder) {
    }

    private ConfigUpgrader createUpgrader() {
        return new ConfigUpgrader(builder -> {
            builder.versionKey("config-version");
            builder.addVersion(1, ConfigurationTransformation.empty());
            this.addVersions((ConfigurationTransformation.VersionedBuilder)builder);
        });
    }

    private void upgradeConfig() {
        ConfigurationNode versionNode = this.config.node("config-version");
        if (versionNode.virtual()) {
            try {
                versionNode.set(this.latestVersion);
            }
            catch (SerializationException e) {
                Util.rethrow(e);
            }
            return;
        }
        ConfigUpgrader.UpgradeResult<@NonNull ConfigurationNode> result = this.createUpgrader().upgrade(this.config);
        if (result.didUpgrade()) {
            Logging.debug(() -> "Upgraded %s from %s to %s".formatted(this.configClass.getName(), result.originalVersion(), result.newVersion()));
        }
    }

    final void readConfig(Class<?> clazz, Object instance) {
        for (Method method : clazz.getDeclaredMethods()) {
            if (!Modifier.isPrivate(method.getModifiers()) || method.getParameterTypes().length != 0 || method.getReturnType() != Void.TYPE) continue;
            try {
                method.setAccessible(true);
                method.invoke(instance, new Object[0]);
            }
            catch (InvocationTargetException ex) {
                Logging.logger().error("Error invoking {}", (Object)method, (Object)ex.getCause());
            }
            catch (Exception ex) {
                Logging.logger().error("Error invoking {}", (Object)method, (Object)ex);
            }
        }
        this.save();
    }

    public void save() {
        try {
            this.loader.save(this.config);
        }
        catch (IOException ex) {
            Logging.logger().error("Could not save {}", (Object)this.configFile, (Object)ex);
        }
    }

    private ConfigurationNode node(String path) {
        return this.config.node(AbstractConfig.splitPath(path));
    }

    protected final void set(String path, Object val) {
        try {
            this.node(path).set(val);
        }
        catch (SerializationException e) {
            Util.rethrow(e);
        }
    }

    protected final String getString(String path, String def) {
        return this.node(path).getString(def);
    }

    public final boolean getBoolean(String path, boolean def) {
        return this.node(path).getBoolean(def);
    }

    protected final int getInt(String path, int def) {
        ConfigurationNode node = this.node(path);
        if (node.virtual()) {
            try {
                node.set(def);
            }
            catch (SerializationException e) {
                Util.rethrow(e);
            }
        }
        return node.getInt(def);
    }

    protected final double getDouble(String path, double def) {
        ConfigurationNode node = this.node(path);
        if (node.virtual()) {
            try {
                node.set(def);
            }
            catch (SerializationException e) {
                Util.rethrow(e);
            }
        }
        return node.getDouble(def);
    }

    protected final <T> T get(TypeToken<T> type, String path, T def) {
        ConfigurationNode node = this.node(path);
        try {
            @Nullable T ret = node.virtual() ? null : (T)node.get(type);
            return ret == null ? (T)AbstractConfig.storeDefault(node, type.getType(), def) : ret;
        }
        catch (SerializationException e) {
            throw Util.rethrow(e);
        }
    }

    protected final <T> List<T> getList(TypeToken<T> elementType, String path, List<T> def) {
        try {
            return this.getList0(elementType, path, def);
        }
        catch (SerializationException e) {
            throw Util.rethrow(e);
        }
    }

    protected final <T> List<T> getList(Class<T> elementType, String path, List<T> def) {
        try {
            return this.getList0(TypeToken.get(elementType), path, def);
        }
        catch (SerializationException e) {
            throw Util.rethrow(e);
        }
    }

    protected final List<String> getStringList(String path, List<String> def) {
        return this.getList(String.class, path, def);
    }

    private <V> List<V> getList0(TypeToken<V> elementType, String path, List<V> def) throws SerializationException {
        ConfigurationNode node = this.node(path);
        Type type = TypeFactory.parameterizedClass(List.class, elementType.getType());
        @Nullable List<V> ret = node.virtual() ? null : (List<V>)node.get(type);
        return ret == null ? AbstractConfig.storeDefault(node, type, def) : ret;
    }

    public final void migrateLevelSection(WorldServer level, String oldName) {
        if (oldName.equals("default")) {
            return;
        }
        ConfigurationNode oldNode = this.config.node("world-settings", oldName);
        if (oldNode.virtual()) {
            return;
        }
        String configName = Util.levelConfigName(level);
        ConfigurationNode newNode = this.config.node("world-settings", configName);
        try {
            newNode.set(oldNode);
            oldNode.set(null);
        }
        catch (SerializationException e) {
            Util.rethrow(e);
        }
        this.save();
    }

    private static <V> V storeDefault(ConfigurationNode node, Type type, V defValue) throws SerializationException {
        Objects.requireNonNull(defValue, "defValue");
        if (node.options().shouldCopyDefaults()) {
            node.set(type, defValue);
        }
        return defValue;
    }

    static Object[] splitPath(String path) {
        Object[] split = path.split("\\.");
        for (int i = 0; i < split.length; ++i) {
            Object s = split[i];
            if (!((String)s).contains("____dot____")) continue;
            split[i] = ((String)s).replace("____dot____", ".");
        }
        return split;
    }
}

