/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.command.commands;

import java.io.IOException;
import java.nio.file.Path;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.minecraft.server.level.WorldServer;
import squaremap.libraries.cloud.commandframework.context.CommandContext;
import squaremap.libraries.cloud.commandframework.extra.confirmation.CommandConfirmationManager;
import squaremap.libraries.cloud.commandframework.minecraft.extras.MinecraftExtrasMetaKeys;
import squaremap.libraries.com.google.inject.Inject;
import xyz.jpenilla.squaremap.common.WorldManager;
import xyz.jpenilla.squaremap.common.command.Commander;
import xyz.jpenilla.squaremap.common.command.Commands;
import xyz.jpenilla.squaremap.common.command.SquaremapCommand;
import xyz.jpenilla.squaremap.common.command.argument.LevelArgument;
import xyz.jpenilla.squaremap.common.config.Messages;
import xyz.jpenilla.squaremap.common.data.DirectoryProvider;
import xyz.jpenilla.squaremap.common.data.MapWorldInternal;
import xyz.jpenilla.squaremap.common.util.Components;
import xyz.jpenilla.squaremap.common.util.FileUtil;

public final class ResetMapCommand
extends SquaremapCommand {
    private final DirectoryProvider directoryProvider;
    private final WorldManager worldManager;

    @Inject
    private ResetMapCommand(Commands commands, DirectoryProvider directoryProvider, WorldManager worldManager) {
        super(commands);
        this.directoryProvider = directoryProvider;
        this.worldManager = worldManager;
    }

    @Override
    public void register() {
        this.commands.registerSubcommand(builder -> builder.literal("resetmap", new String[0]).argument(LevelArgument.of("world")).meta(MinecraftExtrasMetaKeys.DESCRIPTION, Messages.RESETMAP_COMMAND_DESCRIPTION.asComponent()).meta(CommandConfirmationManager.META_CONFIRMATION_REQUIRED, true).permission("squaremap.command.resetmap").handler(this::executeResetMap));
    }

    private void executeResetMap(CommandContext<Commander> context) {
        Commander sender = context.getSender();
        WorldServer world = (WorldServer)context.get("world");
        Path worldTilesDir = this.directoryProvider.getAndCreateTilesDirectory(world);
        try {
            FileUtil.deleteContentsRecursively(worldTilesDir);
        }
        catch (IOException ex) {
            throw new RuntimeException("Could not reset map for level '" + world.ac().a() + "'", ex);
        }
        this.worldManager.getWorldIfEnabled(world).ifPresent(MapWorldInternal::didReset);
        sender.sendMessage(Messages.SUCCESSFULLY_RESET_MAP.withPlaceholders(new TagResolver[]{Components.worldPlaceholder(world)}));
    }
}

