/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.command.commands;

import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.minecraft.core.BlockPosition;
import org.checkerframework.checker.nullness.qual.Nullable;
import squaremap.libraries.cloud.commandframework.ArgumentDescription;
import squaremap.libraries.cloud.commandframework.arguments.standard.IntegerArgument;
import squaremap.libraries.cloud.commandframework.context.CommandContext;
import squaremap.libraries.cloud.commandframework.minecraft.extras.MinecraftExtrasMetaKeys;
import squaremap.libraries.cloud.commandframework.minecraft.extras.RichDescription;
import squaremap.libraries.com.google.inject.Inject;
import xyz.jpenilla.squaremap.common.command.Commander;
import xyz.jpenilla.squaremap.common.command.Commands;
import xyz.jpenilla.squaremap.common.command.PlatformCommands;
import xyz.jpenilla.squaremap.common.command.SquaremapCommand;
import xyz.jpenilla.squaremap.common.command.argument.MapWorldArgument;
import xyz.jpenilla.squaremap.common.config.Messages;
import xyz.jpenilla.squaremap.common.data.MapWorldInternal;
import xyz.jpenilla.squaremap.common.util.Components;

public final class RadiusRenderCommand
extends SquaremapCommand {
    private final PlatformCommands platformCommands;

    @Inject
    private RadiusRenderCommand(Commands commands, PlatformCommands platformCommands) {
        super(commands);
        this.platformCommands = platformCommands;
    }

    @Override
    public void register() {
        this.commands.registerSubcommand(builder -> builder.literal("radiusrender", new String[0]).argument(MapWorldArgument.of("world")).argument(IntegerArgument.builder("radius").withMin(1).build()).argument(this.platformCommands.columnPosArgument("center"), (ArgumentDescription)RichDescription.of(Messages.OPTIONAL_CENTER_ARGUMENT_DESCRIPTION)).meta(MinecraftExtrasMetaKeys.DESCRIPTION, Messages.RADIUSRENDER_COMMAND_DESCRIPTION.asComponent()).permission("squaremap.command.radiusrender").handler(this::executeRadiusRender));
    }

    private void executeRadiusRender(CommandContext<Commander> context) {
        Commander sender = context.getSender();
        MapWorldInternal world = (MapWorldInternal)context.get("world");
        int radius = (Integer)context.get("radius");
        @Nullable BlockPosition center = this.platformCommands.extractColumnPos("center", context);
        if (center == null) {
            center = new BlockPosition(0, 0, 0);
        }
        if (world.renderManager().isRendering()) {
            sender.sendMessage(Messages.RENDER_IN_PROGRESS.withPlaceholders(new TagResolver[]{Components.worldPlaceholder(world)}));
            return;
        }
        sender.sendMessage(Components.miniMessage(Messages.LOG_STARTED_RADIUSRENDER, new TagResolver[]{Components.worldPlaceholder(world)}));
        world.renderManager().startRender(context.get(Commands.RENDER_FACTORY).createRadiusRender(world, center, radius));
    }
}

