/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.command.commands;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import squaremap.libraries.cloud.commandframework.Command;
import squaremap.libraries.cloud.commandframework.arguments.standard.IntegerArgument;
import squaremap.libraries.cloud.commandframework.context.CommandContext;
import squaremap.libraries.cloud.commandframework.minecraft.extras.MinecraftExtrasMetaKeys;
import squaremap.libraries.com.google.inject.Inject;
import xyz.jpenilla.squaremap.common.WorldManager;
import xyz.jpenilla.squaremap.common.command.Commander;
import xyz.jpenilla.squaremap.common.command.Commands;
import xyz.jpenilla.squaremap.common.command.SquaremapCommand;
import xyz.jpenilla.squaremap.common.config.Config;
import xyz.jpenilla.squaremap.common.config.Messages;
import xyz.jpenilla.squaremap.common.util.Components;

public final class ProgressLoggingCommand
extends SquaremapCommand {
    private final WorldManager worldManager;

    @Inject
    private ProgressLoggingCommand(Commands commands, WorldManager worldManager) {
        super(commands);
        this.worldManager = worldManager;
    }

    @Override
    public void register() {
        Command.Builder<Commander> progressLogging = this.commands.rootBuilder().literal("progresslogging", new String[0]).permission("squaremap.command.progresslogging");
        this.commands.register(progressLogging.meta(MinecraftExtrasMetaKeys.DESCRIPTION, Messages.PROGRESSLOGGING_COMMAND_DESCRIPTION.asComponent()).handler(this::executePrint));
        this.commands.register(progressLogging.literal("toggle", new String[0]).meta(MinecraftExtrasMetaKeys.DESCRIPTION, Messages.PROGRESSLOGGING_TOGGLE_COMMAND_DESCRIPTION.asComponent()).handler(this::executeToggle));
        this.commands.register(progressLogging.literal("rate", new String[0]).argument(IntegerArgument.builder("seconds").withMin(1)).meta(MinecraftExtrasMetaKeys.DESCRIPTION, Messages.PROGRESSLOGGING_RATE_COMMAND_DESCRIPTION.asComponent()).handler(this::executeRate));
    }

    private void executePrint(CommandContext<Commander> context) {
        context.getSender().sendMessage(Messages.PROGRESSLOGGING_STATUS_MESSAGE.withPlaceholders(new TagResolver[]{Components.placeholder("seconds", Config.PROGRESS_LOGGING_INTERVAL), Components.placeholder("enabled", (ComponentLike)ProgressLoggingCommand.clickAndHover((ComponentLike)(Config.PROGRESS_LOGGING ? Component.text((String)"\u2714", (TextColor)NamedTextColor.GREEN) : Component.text((String)"\u2716", (TextColor)NamedTextColor.RED))))}));
    }

    private void executeToggle(CommandContext<Commander> context) {
        Config.toggleProgressLogging();
        this.worldManager.worlds().forEach(mapWorld -> mapWorld.renderManager().restartRenderProgressLogging());
        Messages.ComponentMessage message = Config.PROGRESS_LOGGING ? Messages.PROGRESSLOGGING_ENABLED_MESSAGE : Messages.PROGRESSLOGGING_DISABLED_MESSAGE;
        context.getSender().sendMessage(ProgressLoggingCommand.clickAndHover(message));
    }

    private static Component clickAndHover(ComponentLike componentLike) {
        return componentLike.asComponent().hoverEvent((HoverEventSource)Messages.CLICK_TO_TOGGLE.asComponent()).clickEvent(ClickEvent.runCommand((String)("/" + Config.MAIN_COMMAND_LABEL + " progresslogging toggle")));
    }

    private void executeRate(CommandContext<Commander> context) {
        int seconds = (Integer)context.get("seconds");
        Config.setLoggingInterval(seconds);
        this.worldManager.worlds().forEach(mapWorld -> mapWorld.renderManager().restartRenderProgressLogging());
        context.getSender().sendMessage(Messages.PROGRESSLOGGING_SET_RATE_MESSAGE.withPlaceholders(new TagResolver[]{Components.placeholder("seconds", seconds)}));
    }
}

