/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.command.commands;

import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import squaremap.libraries.cloud.commandframework.ArgumentDescription;
import squaremap.libraries.cloud.commandframework.context.CommandContext;
import squaremap.libraries.cloud.commandframework.minecraft.extras.MinecraftExtrasMetaKeys;
import squaremap.libraries.cloud.commandframework.minecraft.extras.RichDescription;
import squaremap.libraries.com.google.inject.Inject;
import xyz.jpenilla.squaremap.common.command.Commander;
import xyz.jpenilla.squaremap.common.command.Commands;
import xyz.jpenilla.squaremap.common.command.SquaremapCommand;
import xyz.jpenilla.squaremap.common.command.argument.MapWorldArgument;
import xyz.jpenilla.squaremap.common.config.Messages;
import xyz.jpenilla.squaremap.common.data.MapWorldInternal;
import xyz.jpenilla.squaremap.common.util.CommandUtil;
import xyz.jpenilla.squaremap.common.util.Components;

public final class PauseRenderCommand
extends SquaremapCommand {
    @Inject
    private PauseRenderCommand(Commands commands) {
        super(commands);
    }

    @Override
    public void register() {
        this.commands.registerSubcommand(builder -> builder.literal("pauserender", new String[0]).argument(MapWorldArgument.optional("world"), (ArgumentDescription)RichDescription.of(Messages.OPTIONAL_WORLD_ARGUMENT_DESCRIPTION)).meta(MinecraftExtrasMetaKeys.DESCRIPTION, Messages.PAUSE_RENDER_COMMAND_DESCRIPTION.asComponent()).permission("squaremap.command.pauserender").handler(this::executePauseRender));
    }

    private void executePauseRender(CommandContext<Commander> context) {
        Commander sender = context.getSender();
        MapWorldInternal world = CommandUtil.resolveWorld(context);
        world.renderManager().pauseRenders(!world.renderManager().rendersPaused());
        if (world.renderManager().rendersPaused()) {
            sender.sendMessage(Messages.PAUSED_RENDER.withPlaceholders(new TagResolver[]{Components.worldPlaceholder(world)}));
        } else {
            sender.sendMessage(Messages.UNPAUSED_RENDER.withPlaceholders(new TagResolver[]{Components.worldPlaceholder(world)}));
        }
    }
}

