/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.command.commands;

import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.Entity;
import squaremap.libraries.cloud.commandframework.ArgumentDescription;
import squaremap.libraries.cloud.commandframework.context.CommandContext;
import squaremap.libraries.cloud.commandframework.minecraft.extras.MinecraftExtrasMetaKeys;
import squaremap.libraries.cloud.commandframework.minecraft.extras.RichDescription;
import squaremap.libraries.com.google.inject.Inject;
import xyz.jpenilla.squaremap.common.command.Commander;
import xyz.jpenilla.squaremap.common.command.Commands;
import xyz.jpenilla.squaremap.common.command.PlatformCommands;
import xyz.jpenilla.squaremap.common.command.SquaremapCommand;
import xyz.jpenilla.squaremap.common.config.Messages;
import xyz.jpenilla.squaremap.common.util.Components;
import xyz.jpenilla.squaremap.common.util.EntityScheduler;

public final class HideShowCommands
extends SquaremapCommand {
    private final PlatformCommands platformCommands;
    private final EntityScheduler entityScheduler;

    @Inject
    private HideShowCommands(Commands commands, PlatformCommands platformCommands, EntityScheduler entityScheduler) {
        super(commands);
        this.platformCommands = platformCommands;
        this.entityScheduler = entityScheduler;
    }

    @Override
    public void register() {
        this.commands.registerSubcommand(builder -> builder.literal("hide", new String[0]).meta(MinecraftExtrasMetaKeys.DESCRIPTION, Messages.HIDE_COMMAND_DESCRIPTION.asComponent()).permission("squaremap.command.hide").handler(this::executeHide));
        this.commands.registerSubcommand(builder -> builder.literal("hide", new String[0]).argument(this.platformCommands.singlePlayerSelectorArgument("player"), (ArgumentDescription)RichDescription.of(Messages.OPTIONAL_PLAYER_ARGUMENT_DESCRIPTION)).meta(MinecraftExtrasMetaKeys.DESCRIPTION, Messages.HIDE_COMMAND_DESCRIPTION.asComponent()).permission("squaremap.command.hide.others").handler(this::executeHide));
        this.commands.registerSubcommand(builder -> builder.literal("show", new String[0]).meta(MinecraftExtrasMetaKeys.DESCRIPTION, Messages.SHOW_COMMAND_DESCRIPTION.asComponent()).permission("squaremap.command.show").handler(this::executeShow));
        this.commands.registerSubcommand(builder -> builder.literal("show", new String[0]).argument(this.platformCommands.singlePlayerSelectorArgument("player"), (ArgumentDescription)RichDescription.of(Messages.OPTIONAL_PLAYER_ARGUMENT_DESCRIPTION)).meta(MinecraftExtrasMetaKeys.DESCRIPTION, Messages.SHOW_COMMAND_DESCRIPTION.asComponent()).permission("squaremap.command.show.others").handler(this::executeShow));
    }

    private void executeHide(CommandContext<Commander> context) {
        EntityPlayer target = this.platformCommands.extractPlayer("player", context);
        Commander sender = context.getSender();
        this.entityScheduler.scheduleFor((Entity)target, () -> {
            if (context.get(Commands.PLAYER_MANAGER).hidden(target.cv())) {
                this.entityScheduler.scheduleFor(sender, () -> sender.sendMessage(Messages.PLAYER_ALREADY_HIDDEN.withPlaceholders(new TagResolver[]{Components.playerPlaceholder(target)})));
                return;
            }
            context.get(Commands.PLAYER_MANAGER).hide(target.cv(), true);
            this.entityScheduler.scheduleFor(sender, () -> sender.sendMessage(Messages.PLAYER_HIDDEN.withPlaceholders(new TagResolver[]{Components.playerPlaceholder(target)})));
        });
    }

    private void executeShow(CommandContext<Commander> context) {
        EntityPlayer target = this.platformCommands.extractPlayer("player", context);
        Commander sender = context.getSender();
        this.entityScheduler.scheduleFor((Entity)target, () -> {
            if (!context.get(Commands.PLAYER_MANAGER).hidden(target.cv())) {
                this.entityScheduler.scheduleFor(sender, () -> sender.sendMessage(Messages.PLAYER_NOT_HIDDEN.withPlaceholders(new TagResolver[]{Components.playerPlaceholder(target)})));
                return;
            }
            context.get(Commands.PLAYER_MANAGER).show(target.cv(), true);
            this.entityScheduler.scheduleFor(sender, () -> sender.sendMessage(Messages.PLAYER_SHOWN.withPlaceholders(new TagResolver[]{Components.playerPlaceholder(target)})));
        });
    }
}

