/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.command.commands;

import java.util.List;
import java.util.function.BiFunction;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import squaremap.libraries.cloud.commandframework.ArgumentDescription;
import squaremap.libraries.cloud.commandframework.CommandHelpHandler;
import squaremap.libraries.cloud.commandframework.CommandManager;
import squaremap.libraries.cloud.commandframework.arguments.CommandArgument;
import squaremap.libraries.cloud.commandframework.arguments.standard.StringArgument;
import squaremap.libraries.cloud.commandframework.context.CommandContext;
import squaremap.libraries.cloud.commandframework.minecraft.extras.AudienceProvider;
import squaremap.libraries.cloud.commandframework.minecraft.extras.MinecraftExtrasMetaKeys;
import squaremap.libraries.cloud.commandframework.minecraft.extras.MinecraftHelp;
import squaremap.libraries.cloud.commandframework.minecraft.extras.RichDescription;
import squaremap.libraries.com.google.inject.Inject;
import xyz.jpenilla.squaremap.common.command.Commander;
import xyz.jpenilla.squaremap.common.command.Commands;
import xyz.jpenilla.squaremap.common.command.SquaremapCommand;
import xyz.jpenilla.squaremap.common.config.Config;
import xyz.jpenilla.squaremap.common.config.Messages;
import xyz.jpenilla.squaremap.common.util.Components;

public final class HelpCommand
extends SquaremapCommand {
    private final MinecraftHelp<Commander> minecraftHelp;
    private final CommandArgument<Commander, String> helpQueryArgument;

    @Inject
    private HelpCommand(Commands commands) {
        super(commands);
        this.minecraftHelp = HelpCommand.createMinecraftHelp(commands.commandManager());
        this.helpQueryArgument = HelpCommand.createHelpQueryArgument(commands);
    }

    @Override
    public void register() {
        this.commands.registerSubcommand(builder -> builder.literal("help", new String[0]).meta(MinecraftExtrasMetaKeys.DESCRIPTION, Messages.HELP_COMMAND_DESCRIPTION.asComponent()).argument(this.helpQueryArgument, (ArgumentDescription)RichDescription.of(Messages.HELP_QUERY_ARGUMENT_DESCRIPTION)).permission("squaremap.command.help").handler(this::executeHelp));
    }

    private void executeHelp(CommandContext<Commander> context) {
        this.minecraftHelp.queryCommands(context.getOptional(this.helpQueryArgument).orElse(""), context.getSender());
    }

    private static CommandArgument<Commander, String> createHelpQueryArgument(Commands commands) {
        CommandHelpHandler<Commander> commandHelpHandler = commands.commandManager().createCommandHelpHandler();
        BiFunction<CommandContext, String, List> suggestions = (context, input) -> commandHelpHandler.queryRootIndex((Commander)context.getSender()).getEntries().stream().map(CommandHelpHandler.VerboseHelpEntry::getSyntaxString).toList();
        return StringArgument.builder("query").greedy().withSuggestionsProvider(suggestions).asOptional().build();
    }

    private static MinecraftHelp<Commander> createMinecraftHelp(CommandManager<Commander> manager) {
        MinecraftHelp<Commander> minecraftHelp = new MinecraftHelp<Commander>(String.format("/%s help", Config.MAIN_COMMAND_LABEL), AudienceProvider.nativeAudience(), manager);
        minecraftHelp.setHelpColors(MinecraftHelp.HelpColors.of(TextColor.color((int)5964031), (TextColor)NamedTextColor.WHITE, TextColor.color((int)12593407), (TextColor)NamedTextColor.GRAY, (TextColor)NamedTextColor.DARK_GRAY));
        minecraftHelp.messageProvider(HelpCommand::helpMessage);
        return minecraftHelp;
    }

    private static Component helpMessage(Commander sender, String key, String ... args) {
        TagResolver[] placeholders = args.length == 0 ? new TagResolver[]{} : new TagResolver[]{Components.placeholder("page", args[0]), Components.placeholder("max_pages", args[1])};
        return Messages.componentMessage("command.message.help." + key).withPlaceholders(placeholders);
    }
}

