/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.command.commands;

import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import squaremap.libraries.cloud.commandframework.ArgumentDescription;
import squaremap.libraries.cloud.commandframework.context.CommandContext;
import squaremap.libraries.cloud.commandframework.minecraft.extras.MinecraftExtrasMetaKeys;
import squaremap.libraries.cloud.commandframework.minecraft.extras.RichDescription;
import squaremap.libraries.com.google.inject.Inject;
import xyz.jpenilla.squaremap.common.command.Commander;
import xyz.jpenilla.squaremap.common.command.Commands;
import xyz.jpenilla.squaremap.common.command.PlayerCommander;
import xyz.jpenilla.squaremap.common.command.SquaremapCommand;
import xyz.jpenilla.squaremap.common.command.argument.MapWorldArgument;
import xyz.jpenilla.squaremap.common.config.Messages;
import xyz.jpenilla.squaremap.common.data.MapWorldInternal;
import xyz.jpenilla.squaremap.common.task.render.RenderFactory;
import xyz.jpenilla.squaremap.common.util.CommandUtil;
import xyz.jpenilla.squaremap.common.util.Components;

public final class FullRenderCommand
extends SquaremapCommand {
    private final RenderFactory renderFactory;

    @Inject
    private FullRenderCommand(Commands commands, RenderFactory renderFactory) {
        super(commands);
        this.renderFactory = renderFactory;
    }

    @Override
    public void register() {
        this.commands.registerSubcommand(builder -> builder.literal("fullrender", new String[0]).argument(MapWorldArgument.optional("world"), (ArgumentDescription)RichDescription.of(Messages.OPTIONAL_WORLD_ARGUMENT_DESCRIPTION)).meta(MinecraftExtrasMetaKeys.DESCRIPTION, Messages.FULLRENDER_COMMAND_DESCRIPTION.asComponent()).permission("squaremap.command.fullrender").handler(this::executeFullRender));
    }

    private void executeFullRender(CommandContext<Commander> context) {
        Commander sender = context.getSender();
        MapWorldInternal world = CommandUtil.resolveWorld(context);
        if (world.renderManager().isRendering()) {
            sender.sendMessage(Messages.RENDER_IN_PROGRESS.withPlaceholders(new TagResolver[]{Components.worldPlaceholder(world)}));
            return;
        }
        if (sender instanceof PlayerCommander) {
            sender.sendMessage(Components.miniMessage(Messages.LOG_STARTED_FULLRENDER, new TagResolver[]{Components.worldPlaceholder(world)}));
        }
        world.renderManager().startRender(this.renderFactory.createFullRender(world));
    }
}

