/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.command.commands;

import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import squaremap.libraries.cloud.commandframework.ArgumentDescription;
import squaremap.libraries.cloud.commandframework.context.CommandContext;
import squaremap.libraries.cloud.commandframework.minecraft.extras.MinecraftExtrasMetaKeys;
import squaremap.libraries.cloud.commandframework.minecraft.extras.RichDescription;
import squaremap.libraries.com.google.inject.Inject;
import xyz.jpenilla.squaremap.common.command.Commander;
import xyz.jpenilla.squaremap.common.command.Commands;
import xyz.jpenilla.squaremap.common.command.SquaremapCommand;
import xyz.jpenilla.squaremap.common.command.argument.MapWorldArgument;
import xyz.jpenilla.squaremap.common.config.Messages;
import xyz.jpenilla.squaremap.common.data.MapWorldInternal;
import xyz.jpenilla.squaremap.common.util.CommandUtil;
import xyz.jpenilla.squaremap.common.util.Components;

public final class CancelRenderCommand
extends SquaremapCommand {
    @Inject
    private CancelRenderCommand(Commands commands) {
        super(commands);
    }

    @Override
    public void register() {
        this.commands.registerSubcommand(builder -> builder.literal("cancelrender", new String[0]).argument(MapWorldArgument.optional("world"), (ArgumentDescription)RichDescription.of(Messages.OPTIONAL_WORLD_ARGUMENT_DESCRIPTION)).meta(MinecraftExtrasMetaKeys.DESCRIPTION, Messages.CANCEL_RENDER_COMMAND_DESCRIPTION.asComponent()).permission("squaremap.command.cancelrender").handler(this::executeCancelRender));
    }

    private void executeCancelRender(CommandContext<Commander> context) {
        Commander sender = context.getSender();
        MapWorldInternal world = CommandUtil.resolveWorld(context);
        if (!world.renderManager().isRendering()) {
            sender.sendMessage(Messages.RENDER_NOT_IN_PROGRESS.withPlaceholders(new TagResolver[]{Components.worldPlaceholder(world)}));
            return;
        }
        sender.sendMessage(Messages.CANCELLED_RENDER.withPlaceholders(new TagResolver[]{Components.worldPlaceholder(world)}));
        world.renderManager().cancelRender();
    }
}

