/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.command.argument;

import java.util.List;
import java.util.Queue;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.kyori.adventure.util.ComponentMessageThrowable;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import org.checkerframework.checker.nullness.qual.Nullable;
import squaremap.libraries.cloud.commandframework.ArgumentDescription;
import squaremap.libraries.cloud.commandframework.arguments.CommandArgument;
import squaremap.libraries.cloud.commandframework.arguments.parser.ArgumentParseResult;
import squaremap.libraries.cloud.commandframework.arguments.parser.ArgumentParser;
import squaremap.libraries.cloud.commandframework.context.CommandContext;
import squaremap.libraries.cloud.commandframework.exceptions.parsing.NoInputProvidedException;
import xyz.jpenilla.squaremap.api.WorldIdentifier;
import xyz.jpenilla.squaremap.common.command.Commands;
import xyz.jpenilla.squaremap.common.config.Messages;
import xyz.jpenilla.squaremap.common.config.WorldConfig;
import xyz.jpenilla.squaremap.common.data.MapWorldInternal;
import xyz.jpenilla.squaremap.common.util.Components;
import xyz.jpenilla.squaremap.common.util.Util;

public final class MapWorldArgument<C>
extends CommandArgument<C, MapWorldInternal> {
    private MapWorldArgument(boolean required, String name, String defaultValue, @Nullable BiFunction<CommandContext<C>, String, List<String>> suggestionsProvider, ArgumentDescription defaultDescription) {
        super(required, name, new Parser(), defaultValue, MapWorldInternal.class, suggestionsProvider, defaultDescription);
    }

    public static <C> Builder<C> builder(String name) {
        return new Builder(name);
    }

    public static <C> MapWorldArgument<C> of(String name) {
        return MapWorldArgument.builder(name).build();
    }

    public static <C> MapWorldArgument<C> optional(String name) {
        return ((Builder)MapWorldArgument.builder(name).asOptional()).build();
    }

    public static <C> MapWorldArgument<C> optional(String name, String defaultValue) {
        return ((Builder)MapWorldArgument.builder(name).asOptionalWithDefault(defaultValue)).build();
    }

    public static final class Parser<C>
    implements ArgumentParser<C, MapWorldInternal> {
        @Override
        public ArgumentParseResult<MapWorldInternal> parse(CommandContext<C> commandContext, Queue<String> inputQueue) {
            @Nullable String input = inputQueue.peek();
            if (input == null) {
                return ArgumentParseResult.failure(new NoInputProvidedException(Parser.class, commandContext));
            }
            @Nullable MinecraftKey key = MinecraftKey.a((String)input);
            if (key == null || key.a().isEmpty()) {
                return ArgumentParseResult.failure(new MapWorldParseException(input, MapWorldParseException.FailureReason.NO_SUCH_WORLD));
            }
            @Nullable WorldServer world = commandContext.get(Commands.SERVER_ACCESS).level(Util.worldIdentifier(key));
            if (world == null) {
                return ArgumentParseResult.failure(new MapWorldParseException(input, MapWorldParseException.FailureReason.NO_SUCH_WORLD));
            }
            WorldConfig worldConfig = commandContext.get(Commands.CONFIG_MANAGER).worldConfig(world);
            if (!worldConfig.MAP_ENABLED) {
                return ArgumentParseResult.failure(new MapWorldParseException(input, MapWorldParseException.FailureReason.MAP_NOT_ENABLED));
            }
            inputQueue.remove();
            return ArgumentParseResult.success(commandContext.get(Commands.WORLD_MANAGER).getWorldIfEnabled(world).orElseThrow());
        }

        @Override
        public List<String> suggestions(CommandContext<C> commandContext, String input) {
            return commandContext.get(Commands.WORLD_MANAGER).worlds().stream().flatMap(mapWorld -> {
                WorldIdentifier identifier = mapWorld.identifier();
                if (!input.isBlank() && identifier.namespace().equals("minecraft")) {
                    return Stream.of(identifier.value(), identifier.asString());
                }
                return Stream.of(identifier.asString());
            }).toList();
        }
    }

    public static final class Builder<C>
    extends CommandArgument.TypedBuilder<C, MapWorldInternal, Builder<C>> {
        private Builder(String name) {
            super(MapWorldInternal.class, name);
        }

        public MapWorldArgument<C> build() {
            return new MapWorldArgument(this.isRequired(), this.getName(), this.getDefaultValue(), this.getSuggestionsProvider(), this.getDefaultDescription());
        }
    }

    public static final class MapWorldParseException
    extends IllegalArgumentException
    implements ComponentMessageThrowable {
        private static final long serialVersionUID = 3072715326923004782L;
        private final String input;
        private final FailureReason reason;

        public MapWorldParseException(String input, FailureReason reason) {
            this.input = input;
            this.reason = reason;
        }

        public Component componentMessage() {
            return this.reason.failureMessage.get().withPlaceholders(new TagResolver[]{Components.placeholder("world", this.input)});
        }

        @Override
        public String getMessage() {
            return PlainTextComponentSerializer.plainText().serialize(this.componentMessage());
        }

        public static enum FailureReason {
            NO_SUCH_WORLD(() -> Messages.NO_SUCH_WORLD),
            MAP_NOT_ENABLED(() -> Messages.MAP_NOT_ENABLED_FOR_WORLD);

            private final Supplier<Messages.ComponentMessage> failureMessage;

            private FailureReason(Supplier<Messages.ComponentMessage> failureMessage) {
                this.failureMessage = failureMessage;
            }
        }
    }
}

